/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SASTokenParameter
implements JsonSerializable<SASTokenParameter> {
    private final String storageResourceUri;
    private String token;
    private Boolean useManagedIdentity;

    public SASTokenParameter(String storageResourceUri) {
        this.storageResourceUri = storageResourceUri;
    }

    public String getStorageResourceUri() {
        return this.storageResourceUri;
    }

    public String getToken() {
        return this.token;
    }

    public SASTokenParameter setToken(String token) {
        this.token = token;
        return this;
    }

    public Boolean isUseManagedIdentity() {
        return this.useManagedIdentity;
    }

    public SASTokenParameter setUseManagedIdentity(Boolean useManagedIdentity) {
        this.useManagedIdentity = useManagedIdentity;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageResourceUri", this.storageResourceUri);
        jsonWriter.writeStringField("token", this.token);
        jsonWriter.writeBooleanField("useManagedIdentity", this.useManagedIdentity);
        return jsonWriter.writeEndObject();
    }

    public static SASTokenParameter fromJson(JsonReader jsonReader) throws IOException {
        return (SASTokenParameter)jsonReader.readObject(reader -> {
            boolean storageResourceUriFound = false;
            String storageResourceUri = null;
            String token = null;
            Boolean useManagedIdentity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageResourceUri".equals(fieldName)) {
                    storageResourceUri = reader.getString();
                    storageResourceUriFound = true;
                    continue;
                }
                if ("token".equals(fieldName)) {
                    token = reader.getString();
                    continue;
                }
                if ("useManagedIdentity".equals(fieldName)) {
                    useManagedIdentity = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (storageResourceUriFound) {
                SASTokenParameter deserializedSASTokenParameter = new SASTokenParameter(storageResourceUri);
                deserializedSASTokenParameter.token = token;
                deserializedSASTokenParameter.useManagedIdentity = useManagedIdentity;
                return deserializedSASTokenParameter;
            }
            throw new IllegalStateException("Missing required property: storageResourceUri");
        });
    }
}

