/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationUtils;
import com.azure.security.keyvault.administration.implementation.models.FullBackupOperation;
import com.azure.security.keyvault.administration.implementation.models.Permission;
import com.azure.security.keyvault.administration.implementation.models.RestoreOperation;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignment;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentProperties;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentPropertiesWithScope;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinition;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionProperties;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperation;
import com.azure.security.keyvault.administration.models.KeyVaultBackupOperation;
import com.azure.security.keyvault.administration.models.KeyVaultDataAction;
import com.azure.security.keyvault.administration.models.KeyVaultLongRunningOperation;
import com.azure.security.keyvault.administration.models.KeyVaultPermission;
import com.azure.security.keyvault.administration.models.KeyVaultRestoreOperation;
import com.azure.security.keyvault.administration.models.KeyVaultRoleAssignment;
import com.azure.security.keyvault.administration.models.KeyVaultRoleAssignmentProperties;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinition;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinitionType;
import com.azure.security.keyvault.administration.models.KeyVaultRoleScope;
import com.azure.security.keyvault.administration.models.KeyVaultRoleType;
import com.azure.security.keyvault.administration.models.KeyVaultSelectiveKeyRestoreOperation;
import com.azure.security.keyvault.administration.models.SetRoleDefinitionOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class KeyVaultAdministrationUtil {
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";

    KeyVaultAdministrationUtil() {
    }

    static <E extends HttpResponseException> Mono<Response<Void>> swallowExceptionForStatusCodeAsync(int statusCode, E httpResponseException, ClientLogger logger) {
        try {
            return Mono.just(KeyVaultAdministrationUtil.swallowExceptionForStatusCodeSync(statusCode, httpResponseException, logger));
        }
        catch (RuntimeException e) {
            return Mono.error((Throwable)e);
        }
    }

    static <E extends HttpResponseException> Response<Void> swallowExceptionForStatusCodeSync(int statusCode, E httpResponseException, ClientLogger logger) {
        HttpResponse httpResponse = httpResponseException.getResponse();
        if (httpResponse.getStatusCode() == statusCode) {
            return new SimpleResponse(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null);
        }
        throw logger.logExceptionAsError(httpResponseException);
    }

    static RoleAssignmentCreateParameters validateAndGetRoleAssignmentCreateParameters(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName) {
        KeyVaultAdministrationUtil.validateRoleAssignmentParameters(roleScope, roleAssignmentName);
        Objects.requireNonNull(principalId, String.format("%s cannot be null.", "'principalId'"));
        Objects.requireNonNull(roleDefinitionId, String.format("%s cannot be null.", "'roleDefinitionId'"));
        RoleAssignmentProperties roleAssignmentProperties = new RoleAssignmentProperties(roleDefinitionId, principalId);
        return new RoleAssignmentCreateParameters(roleAssignmentProperties);
    }

    static RoleDefinitionCreateParameters validateAndGetRoleDefinitionCreateParameters(SetRoleDefinitionOptions options) {
        Objects.requireNonNull(options, String.format("%s cannot be null.", "'options'"));
        Objects.requireNonNull(options.getRoleScope(), String.format("%s cannot be null.", "'options.getRoleScope()'"));
        Objects.requireNonNull(options.getRoleDefinitionName(), String.format("%s cannot be null.", "'options.getRoleDefinitionName()'"));
        List<Permission> permissions = null;
        if (options.getPermissions() != null) {
            permissions = options.getPermissions().stream().map(keyVaultPermission -> new Permission().setActions(keyVaultPermission.getActions()).setNotActions(keyVaultPermission.getNotActions()).setDataActions(keyVaultPermission.getDataActions()).setNotDataActions(keyVaultPermission.getNotDataActions())).collect(Collectors.toList());
        }
        RoleDefinitionProperties roleDefinitionProperties = new RoleDefinitionProperties().setRoleName(options.getRoleDefinitionName()).setAssignableScopes(options.getAssignableScopes()).setDescription(options.getDescription()).setPermissions(permissions);
        return new RoleDefinitionCreateParameters(roleDefinitionProperties);
    }

    static void validateRoleAssignmentParameters(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        Objects.requireNonNull(roleScope, String.format("%s cannot be null.", "'roleScope'"));
        Objects.requireNonNull(roleAssignmentName, String.format("%s cannot be null.", "'roleAssignmentName'"));
    }

    static void validateRoleDefinitionParameters(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        Objects.requireNonNull(roleScope, String.format("%s cannot be null.", "'roleScope'"));
        Objects.requireNonNull(roleDefinitionName, String.format("%s cannot be null.", "'roleDefinitionName'"));
    }

    static PagedResponse<KeyVaultRoleDefinition> transformRoleDefinitionsPagedResponse(PagedResponse<RoleDefinition> pagedResponse) {
        ArrayList<KeyVaultRoleDefinition> keyVaultRoleDefinitions = new ArrayList<KeyVaultRoleDefinition>();
        for (RoleDefinition roleDefinition : pagedResponse.getValue()) {
            keyVaultRoleDefinitions.add(KeyVaultAdministrationUtil.roleDefinitionToKeyVaultRoleDefinition(roleDefinition));
        }
        return new TransformedPagedResponse(keyVaultRoleDefinitions, pagedResponse);
    }

    static Response<KeyVaultRoleDefinition> transformRoleDefinitionResponse(Response<RoleDefinition> response) {
        KeyVaultRoleDefinition keyVaultRoleDefinition = KeyVaultAdministrationUtil.roleDefinitionToKeyVaultRoleDefinition((RoleDefinition)response.getValue());
        return new TransformedResponse<KeyVaultRoleDefinition, RoleDefinition>(keyVaultRoleDefinition, response);
    }

    static KeyVaultRoleDefinition roleDefinitionToKeyVaultRoleDefinition(RoleDefinition roleDefinition) {
        ArrayList<KeyVaultPermission> keyVaultPermissions = new ArrayList<KeyVaultPermission>();
        for (Permission permission : roleDefinition.getPermissions()) {
            keyVaultPermissions.add(new KeyVaultPermission(permission.getActions(), permission.getNotActions(), permission.getDataActions().stream().map(dataAction -> KeyVaultDataAction.fromString(dataAction.toString())).collect(Collectors.toList()), permission.getNotDataActions().stream().map(notDataAction -> KeyVaultDataAction.fromString(notDataAction.toString())).collect(Collectors.toList())));
        }
        return new KeyVaultRoleDefinition(roleDefinition.getId(), roleDefinition.getName(), KeyVaultRoleDefinitionType.fromString(roleDefinition.getType().toString()), roleDefinition.getRoleName(), roleDefinition.getDescription(), KeyVaultRoleType.fromString(roleDefinition.getRoleType().toString()), keyVaultPermissions, roleDefinition.getAssignableScopes().stream().map(roleScope -> KeyVaultRoleScope.fromString(roleScope.toString())).collect(Collectors.toList()));
    }

    static PagedResponse<KeyVaultRoleAssignment> transformRoleAssignmentsPagedResponse(PagedResponse<RoleAssignment> pagedResponse) {
        ArrayList<KeyVaultRoleAssignment> keyVaultRoleAssignments = new ArrayList<KeyVaultRoleAssignment>();
        for (RoleAssignment roleAssignment : pagedResponse.getValue()) {
            keyVaultRoleAssignments.add(KeyVaultAdministrationUtil.roleAssignmentToKeyVaultRoleAssignment(roleAssignment));
        }
        return new TransformedPagedResponse(keyVaultRoleAssignments, pagedResponse);
    }

    static Response<KeyVaultRoleAssignment> transformRoleAssignmentResponse(Response<RoleAssignment> response) {
        KeyVaultRoleAssignment keyVaultRoleAssignment = KeyVaultAdministrationUtil.roleAssignmentToKeyVaultRoleAssignment((RoleAssignment)response.getValue());
        return new TransformedResponse<KeyVaultRoleAssignment, RoleAssignment>(keyVaultRoleAssignment, response);
    }

    static KeyVaultRoleAssignment roleAssignmentToKeyVaultRoleAssignment(RoleAssignment roleAssignment) {
        RoleAssignmentPropertiesWithScope propertiesWithScope = roleAssignment.getProperties();
        return new KeyVaultRoleAssignment(roleAssignment.getId(), roleAssignment.getName(), roleAssignment.getType(), new KeyVaultRoleAssignmentProperties(propertiesWithScope.getRoleDefinitionId(), propertiesWithScope.getPrincipalId(), KeyVaultRoleScope.fromString(propertiesWithScope.getScope().toString())));
    }

    static LongRunningOperationStatus toLongRunningOperationStatus(String operationStatus) {
        switch (operationStatus) {
            case "inprogress": {
                return LongRunningOperationStatus.IN_PROGRESS;
            }
            case "succeeded": {
                return LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
            }
            case "failed": {
                return LongRunningOperationStatus.FAILED;
            }
        }
        return LongRunningOperationStatus.fromString((String)"POLLING_FAILED", (boolean)true);
    }

    static <O> KeyVaultLongRunningOperation transformToLongRunningOperation(O operation) {
        if (operation instanceof RestoreOperation) {
            RestoreOperation restoreOperation = (RestoreOperation)operation;
            return new KeyVaultRestoreOperation(restoreOperation.getStatus(), restoreOperation.getStatusDetails(), KeyVaultAdministrationUtils.createKeyVaultErrorFromError(restoreOperation.getError()), restoreOperation.getJobId(), restoreOperation.getStartTime(), restoreOperation.getEndTime());
        }
        if (operation instanceof SelectiveKeyRestoreOperation) {
            SelectiveKeyRestoreOperation selectiveKeyRestoreOperation = (SelectiveKeyRestoreOperation)operation;
            return new KeyVaultSelectiveKeyRestoreOperation(selectiveKeyRestoreOperation.getStatus(), selectiveKeyRestoreOperation.getStatusDetails(), KeyVaultAdministrationUtils.createKeyVaultErrorFromError(selectiveKeyRestoreOperation.getError()), selectiveKeyRestoreOperation.getJobId(), selectiveKeyRestoreOperation.getStartTime(), selectiveKeyRestoreOperation.getEndTime());
        }
        if (operation instanceof FullBackupOperation) {
            FullBackupOperation fullBackupOperation = (FullBackupOperation)operation;
            return new KeyVaultBackupOperation(fullBackupOperation.getStatus(), fullBackupOperation.getStatusDetails(), KeyVaultAdministrationUtils.createKeyVaultErrorFromError(fullBackupOperation.getError()), fullBackupOperation.getJobId(), fullBackupOperation.getStartTime(), fullBackupOperation.getEndTime(), fullBackupOperation.getAzureStorageBlobContainerUri());
        }
        throw new UnsupportedOperationException();
    }

    static Context enableSyncRestProxy(Context context) {
        return context.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    private static final class TransformedPagedResponse<L extends List<T>, T, U>
    implements PagedResponse<T> {
        private final L output;
        private final PagedResponse<U> pagedResponse;

        TransformedPagedResponse(L output, PagedResponse<U> inputPagedResponse) {
            this.output = output;
            this.pagedResponse = inputPagedResponse;
        }

        public void close() throws IOException {
        }

        public IterableStream<T> getElements() {
            return new IterableStream(this.output);
        }

        public String getContinuationToken() {
            return (String)this.pagedResponse.getContinuationToken();
        }

        public int getStatusCode() {
            return this.pagedResponse.getStatusCode();
        }

        public HttpHeaders getHeaders() {
            return this.pagedResponse.getHeaders();
        }

        public HttpRequest getRequest() {
            return this.pagedResponse.getRequest();
        }

        public List<T> getValue() {
            return this.output;
        }
    }

    private static final class TransformedResponse<T, U>
    implements Response<T> {
        private final T output;
        private final Response<U> response;

        TransformedResponse(T output, Response<U> response) {
            this.output = output;
            this.response = response;
        }

        public int getStatusCode() {
            return this.response.getStatusCode();
        }

        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }

        public HttpRequest getRequest() {
            return this.response.getRequest();
        }

        public T getValue() {
            return this.output;
        }
    }
}

