/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.confidentialledger;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.security.confidentialledger.ConfidentialLedgerClientBuilder;
import com.azure.security.confidentialledger.implementation.ConfidentialLedgerClientImpl;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ConfidentialLedgerClientBuilder.class, isAsync=true)
public final class ConfidentialLedgerAsyncClient {
    private final ConfidentialLedgerClientImpl serviceClient;

    ConfidentialLedgerAsyncClient(ConfidentialLedgerClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getConstitutionWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getConstitutionWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listConsortiumMembers(RequestOptions requestOptions) {
        return this.serviceClient.listConsortiumMembersAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEnclaveQuotesWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getEnclaveQuotesWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listCollections(RequestOptions requestOptions) {
        return this.serviceClient.listCollectionsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLedgerEntries(RequestOptions requestOptions) {
        return this.serviceClient.listLedgerEntriesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createLedgerEntryWithResponse(BinaryData entry, RequestOptions requestOptions) {
        return this.serviceClient.createLedgerEntryWithResponseAsync(entry, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLedgerEntryWithResponse(String transactionId, RequestOptions requestOptions) {
        return this.serviceClient.getLedgerEntryWithResponseAsync(transactionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getReceiptWithResponse(String transactionId, RequestOptions requestOptions) {
        return this.serviceClient.getReceiptWithResponseAsync(transactionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTransactionStatusWithResponse(String transactionId, RequestOptions requestOptions) {
        return this.serviceClient.getTransactionStatusWithResponseAsync(transactionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCurrentLedgerEntryWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getCurrentLedgerEntryWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteUserWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.deleteUserWithResponseAsync(userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUserWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.getUserWithResponseAsync(userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateUserWithResponse(String userId, BinaryData userDetails, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateUserWithResponseAsync(userId, userDetails, requestOptions);
    }
}

