/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.confidentialledger.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.confidentialledger.ConfidentialLedgerServiceVersion;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class ConfidentialLedgerClientImpl {
    private final ConfidentialLedgerClientService service;
    private final String ledgerEndpoint;
    private final ConfidentialLedgerServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getLedgerEndpoint() {
        return this.ledgerEndpoint;
    }

    public ConfidentialLedgerServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ConfidentialLedgerClientImpl(String ledgerEndpoint, ConfidentialLedgerServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), ledgerEndpoint, serviceVersion);
    }

    public ConfidentialLedgerClientImpl(HttpPipeline httpPipeline, String ledgerEndpoint, ConfidentialLedgerServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), ledgerEndpoint, serviceVersion);
    }

    public ConfidentialLedgerClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String ledgerEndpoint, ConfidentialLedgerServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.ledgerEndpoint = ledgerEndpoint;
        this.serviceVersion = serviceVersion;
        this.service = (ConfidentialLedgerClientService)RestProxy.create(ConfidentialLedgerClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getConstitutionWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getConstitution(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getConstitutionWithResponseAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getConstitution(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getConstitutionWithResponse(RequestOptions requestOptions) {
        return (Response)this.getConstitutionWithResponseAsync(requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listConsortiumMembersSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listConsortiumMembers(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "members"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listConsortiumMembersSinglePageAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listConsortiumMembers(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "members"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listConsortiumMembersAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listConsortiumMembersSinglePageAsync(requestOptions), nextLink -> this.listConsortiumMembersNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listConsortiumMembersAsync(RequestOptions requestOptions, Context context) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listConsortiumMembersSinglePageAsync(requestOptions, context), nextLink -> this.listConsortiumMembersNextSinglePageAsync((String)nextLink, requestOptionsForNextPage, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listConsortiumMembers(RequestOptions requestOptions) {
        return new PagedIterable(this.listConsortiumMembersAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEnclaveQuotesWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEnclaveQuotes(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEnclaveQuotesWithResponseAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getEnclaveQuotes(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEnclaveQuotesWithResponse(RequestOptions requestOptions) {
        return (Response)this.getEnclaveQuotesWithResponseAsync(requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listCollectionsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCollections(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "collections"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listCollectionsSinglePageAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listCollections(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "collections"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listCollectionsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listCollectionsSinglePageAsync(requestOptions), nextLink -> this.listCollectionsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listCollectionsAsync(RequestOptions requestOptions, Context context) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listCollectionsSinglePageAsync(requestOptions, context), nextLink -> this.listCollectionsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listCollections(RequestOptions requestOptions) {
        return new PagedIterable(this.listCollectionsAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listLedgerEntriesSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listLedgerEntries(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "entries"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listLedgerEntriesSinglePageAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listLedgerEntries(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "entries"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLedgerEntriesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listLedgerEntriesSinglePageAsync(requestOptions), nextLink -> this.listLedgerEntriesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLedgerEntriesAsync(RequestOptions requestOptions, Context context) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listLedgerEntriesSinglePageAsync(requestOptions, context), nextLink -> this.listLedgerEntriesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listLedgerEntries(RequestOptions requestOptions) {
        return new PagedIterable(this.listLedgerEntriesAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createLedgerEntryWithResponseAsync(BinaryData entry, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createLedgerEntry(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), entry, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createLedgerEntryWithResponseAsync(BinaryData entry, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.createLedgerEntry(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), entry, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createLedgerEntryWithResponse(BinaryData entry, RequestOptions requestOptions) {
        return (Response)this.createLedgerEntryWithResponseAsync(entry, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLedgerEntryWithResponseAsync(String transactionId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getLedgerEntry(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), transactionId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLedgerEntryWithResponseAsync(String transactionId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getLedgerEntry(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), transactionId, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getLedgerEntryWithResponse(String transactionId, RequestOptions requestOptions) {
        return (Response)this.getLedgerEntryWithResponseAsync(transactionId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getReceiptWithResponseAsync(String transactionId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getReceipt(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), transactionId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getReceiptWithResponseAsync(String transactionId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getReceipt(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), transactionId, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getReceiptWithResponse(String transactionId, RequestOptions requestOptions) {
        return (Response)this.getReceiptWithResponseAsync(transactionId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTransactionStatusWithResponseAsync(String transactionId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTransactionStatus(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), transactionId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTransactionStatusWithResponseAsync(String transactionId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getTransactionStatus(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), transactionId, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTransactionStatusWithResponse(String transactionId, RequestOptions requestOptions) {
        return (Response)this.getTransactionStatusWithResponseAsync(transactionId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCurrentLedgerEntryWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCurrentLedgerEntry(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCurrentLedgerEntryWithResponseAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getCurrentLedgerEntry(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCurrentLedgerEntryWithResponse(RequestOptions requestOptions) {
        return (Response)this.getCurrentLedgerEntryWithResponseAsync(requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteUserWithResponseAsync(String userId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteUser(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), userId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteUserWithResponseAsync(String userId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.deleteUser(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), userId, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteUserWithResponse(String userId, RequestOptions requestOptions) {
        return (Response)this.deleteUserWithResponseAsync(userId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUserWithResponseAsync(String userId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUser(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), userId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUserWithResponseAsync(String userId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getUser(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), userId, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getUserWithResponse(String userId, RequestOptions requestOptions) {
        return (Response)this.getUserWithResponseAsync(userId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateUserWithResponseAsync(String userId, BinaryData userDetails, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateUser(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), userId, userDetails, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateUserWithResponseAsync(String userId, BinaryData userDetails, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.createOrUpdateUser(this.getLedgerEndpoint(), this.getServiceVersion().getVersion(), userId, userDetails, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateUserWithResponse(String userId, BinaryData userDetails, RequestOptions requestOptions) {
        return (Response)this.createOrUpdateUserWithResponseAsync(userId, userDetails, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listConsortiumMembersNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listConsortiumMembersNext(nextLink, this.getLedgerEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "members"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listConsortiumMembersNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listConsortiumMembersNext(nextLink, this.getLedgerEndpoint(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "members"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listCollectionsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCollectionsNext(nextLink, this.getLedgerEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "collections"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listCollectionsNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listCollectionsNext(nextLink, this.getLedgerEndpoint(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "collections"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listLedgerEntriesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listLedgerEntriesNext(nextLink, this.getLedgerEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "entries"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listLedgerEntriesNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listLedgerEntriesNext(nextLink, this.getLedgerEndpoint(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "entries"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="{ledgerEndpoint}")
    @ServiceInterface(name="ConfidentialLedgerCl")
    private static interface ConfidentialLedgerClientService {
        @Get(value="/app/governance/constitution")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getConstitution(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/app/governance/members")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listConsortiumMembers(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/app/enclaveQuotes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getEnclaveQuotes(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/app/collections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listCollections(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/app/transactions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listLedgerEntries(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/app/transactions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createLedgerEntry(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BinaryData var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/app/transactions/{transactionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getLedgerEntry(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="transactionId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/app/transactions/{transactionId}/receipt")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getReceipt(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="transactionId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/app/transactions/{transactionId}/status")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getTransactionStatus(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="transactionId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/app/transactions/current")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCurrentLedgerEntry(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/app/users/{userId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteUser(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="userId", encoded=true) String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/app/users/{userId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getUser(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="userId", encoded=true) String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Patch(value="/app/users/{userId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createOrUpdateUser(@HostParam(value="ledgerEndpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="userId", encoded=true) String var3, @BodyParam(value="application/merge-patch+json") BinaryData var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listConsortiumMembersNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="ledgerEndpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listCollectionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="ledgerEndpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listLedgerEntriesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="ledgerEndpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

