/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.models;

import com.azure.security.attestation.models.AttestationSigningKey;
import com.azure.security.attestation.models.AttestationTokenValidationOptions;
import java.security.cert.X509Certificate;
import java.util.Objects;

public final class PolicyManagementCertificateOptions {
    private AttestationTokenValidationOptions validationOptions;
    private final X509Certificate certificate;
    private final AttestationSigningKey signer;

    public PolicyManagementCertificateOptions(X509Certificate certificate, AttestationSigningKey signingKey) {
        Objects.requireNonNull(certificate);
        Objects.requireNonNull(signingKey);
        this.certificate = certificate;
        this.signer = signingKey;
    }

    public PolicyManagementCertificateOptions setValidationOptions(AttestationTokenValidationOptions validationOptions) {
        this.validationOptions = validationOptions;
        return this;
    }

    public AttestationTokenValidationOptions getValidationOptions() {
        return this.validationOptions;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public AttestationSigningKey getAttestationSigner() {
        return this.signer;
    }
}

