/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.models;

import com.azure.security.attestation.models.AttestationSigner;
import com.azure.security.attestation.models.AttestationToken;
import java.time.Duration;
import java.util.function.BiConsumer;

public final class AttestationTokenValidationOptions {
    private boolean validateToken = true;
    private String expectedIssuer;
    private boolean validateExpiresOn = true;
    private boolean validateNotBefore = true;
    private Duration validationSlack = Duration.ZERO;
    private BiConsumer<AttestationToken, AttestationSigner> validationCallback = null;

    public AttestationTokenValidationOptions setValidateToken(boolean validateToken) {
        this.validateToken = validateToken;
        return this;
    }

    public boolean isValidateToken() {
        return this.validateToken;
    }

    public AttestationTokenValidationOptions setExpectedIssuer(String expectedIssuer) {
        this.expectedIssuer = expectedIssuer;
        return this;
    }

    public String getExpectedIssuer() {
        return this.expectedIssuer;
    }

    public AttestationTokenValidationOptions setValidationCallback(BiConsumer<AttestationToken, AttestationSigner> callback) {
        this.validationCallback = callback;
        return this;
    }

    public BiConsumer<AttestationToken, AttestationSigner> getValidationCallback() {
        return this.validationCallback;
    }

    public AttestationTokenValidationOptions setValidateExpiresOn(boolean validateExpiresOn) {
        this.validateExpiresOn = validateExpiresOn;
        return this;
    }

    public boolean isValidateExpiresOn() {
        return this.validateExpiresOn;
    }

    public AttestationTokenValidationOptions setValidateNotBefore(boolean validateNotBefore) {
        this.validateNotBefore = validateNotBefore;
        return this;
    }

    public boolean isValidateNotBefore() {
        return this.validateNotBefore;
    }

    public AttestationTokenValidationOptions setValidationSlack(Duration slack) {
        this.validationSlack = slack;
        return this;
    }

    public Duration getValidationSlack() {
        return this.validationSlack;
    }
}

