/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.security.attestation.implementation.models.AttestationSignerImpl;
import com.azure.security.attestation.models.AttestationSigner;
import com.azure.security.attestation.models.AttestationSigningKey;
import com.azure.security.attestation.models.AttestationToken;
import com.azure.security.attestation.models.AttestationTokenValidationOptions;
import com.nimbusds.jose.Header;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.PlainObject;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.crypto.opts.AllowWeakRSAKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class AttestationTokenImpl
implements AttestationToken {
    private static final SerializerAdapter SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();
    private final ClientLogger logger;
    private final String rawToken;
    private final Header header;
    private final JWSHeader jwsHeader;
    private final Payload payload;
    final AtomicReference<String> issuer = new AtomicReference();
    final AtomicReference<OffsetDateTime> issuedAt = new AtomicReference();
    final AtomicReference<OffsetDateTime> expiresOn = new AtomicReference();
    final AtomicReference<OffsetDateTime> notBeforeTime = new AtomicReference();
    static final String EMPTY_TOKEN = "eyJhbGciOiJub25lIn0..";

    public AttestationTokenImpl(String serializedToken) {
        JOSEObject tokenAsJose;
        this.logger = new ClientLogger(AttestationTokenImpl.class);
        this.rawToken = serializedToken;
        try {
            tokenAsJose = JOSEObject.parse((String)serializedToken);
        }
        catch (ParseException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e.toString()));
        }
        this.header = tokenAsJose.getHeader();
        this.jwsHeader = !this.header.getAlgorithm().getName().equals("none") ? (JWSHeader)this.header : null;
        this.payload = tokenAsJose.getPayload();
    }

    @Override
    public <T> T getBody(Class<T> returnType) {
        if (this.payload.toString().length() == 0) {
            return null;
        }
        try {
            return (T)SERIALIZER_ADAPTER.deserialize(this.payload.toString(), returnType, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
    }

    @Override
    public String serialize() {
        return this.rawToken;
    }

    @Override
    public String getAlgorithm() {
        return this.header.getAlgorithm().getName();
    }

    @Override
    public String getKeyId() {
        return this.jwsHeader != null ? this.jwsHeader.getKeyID() : null;
    }

    @Override
    public AttestationSigner getCertificateChain() {
        if (this.jwsHeader != null) {
            List certChain = this.jwsHeader.getX509CertChain();
            return AttestationSignerImpl.fromCertificateChain(certChain);
        }
        return null;
    }

    @Override
    public String getJsonWebKeyUrl() {
        return this.jwsHeader != null ? this.jwsHeader.getJWKURL().toString() : null;
    }

    @Override
    public AttestationSigner getJsonWebKey() {
        if (this.jwsHeader != null) {
            JWK jwk = this.jwsHeader.getJWK();
            if (jwk == null) {
                return null;
            }
            return AttestationSignerImpl.fromJWK(jwk);
        }
        return null;
    }

    @Override
    public BinaryData getSha256Thumbprint() {
        return this.jwsHeader != null ? BinaryData.fromBytes((byte[])this.jwsHeader.getX509CertSHA256Thumbprint().decode()) : null;
    }

    @Override
    public BinaryData getThumbprint() {
        return this.jwsHeader != null ? BinaryData.fromBytes((byte[])this.jwsHeader.getX509CertThumbprint().decode()) : null;
    }

    @Override
    public String getX509Url() {
        return this.jwsHeader != null ? this.jwsHeader.getX509CertURL().toString() : null;
    }

    @Override
    public String[] getCritical() {
        return this.jwsHeader.getCriticalParams().toArray(new String[0]);
    }

    @Override
    public String getType() {
        return this.jwsHeader.getType().getType();
    }

    @Override
    public String getContentType() {
        return this.jwsHeader.getContentType();
    }

    @Override
    public String getIssuer() {
        Map claimSet;
        if (this.issuer.get() == null && (claimSet = this.payload.toJSONObject()) != null) {
            JWTClaimsSet claimsSet;
            try {
                claimsSet = JWTClaimsSet.parse((Map)claimSet);
            }
            catch (ParseException e) {
                throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
            }
            this.issuer.set(claimsSet.getIssuer());
        }
        return this.issuer.get();
    }

    @Override
    public OffsetDateTime getIssuedAt() {
        Object iatObject;
        Map claimSet;
        if (this.issuedAt.get() == null && (claimSet = this.payload.toJSONObject()) != null && (iatObject = claimSet.get("iat")) != null) {
            if (!(iatObject instanceof Long)) {
                throw this.logger.logExceptionAsError(new RuntimeException(String.format("Invalid type for IssuedAt: %s", iatObject.getClass().getName())));
            }
            long iat = (Long)iatObject;
            this.issuedAt.set(OffsetDateTime.ofInstant(Instant.ofEpochSecond(iat), ZoneOffset.UTC));
        }
        return this.issuedAt.get();
    }

    @Override
    public OffsetDateTime getExpiresOn() {
        Object expObject;
        Map claimSet;
        if (this.expiresOn.get() == null && (claimSet = this.payload.toJSONObject()) != null && (expObject = claimSet.get("exp")) != null) {
            if (!(expObject instanceof Long)) {
                throw this.logger.logExceptionAsError(new RuntimeException(String.format("Invalid type for ExpiresOn: %s", this.expiresOn.getClass().getName())));
            }
            long exp = (Long)expObject;
            this.expiresOn.set(OffsetDateTime.ofInstant(Instant.ofEpochSecond(exp), ZoneOffset.UTC));
        }
        return this.expiresOn.get();
    }

    @Override
    public OffsetDateTime getNotBefore() {
        Object nbfObject;
        Map claimSet;
        if (this.notBeforeTime.get() == null && (claimSet = this.payload.toJSONObject()) != null && (nbfObject = claimSet.get("nbf")) != null) {
            if (!(nbfObject instanceof Long)) {
                throw this.logger.logExceptionAsError(new RuntimeException(String.format("Invalid type for NotBefore: %s", nbfObject.getClass().getName())));
            }
            long nbf = (Long)nbfObject;
            this.notBeforeTime.set(OffsetDateTime.ofInstant(Instant.ofEpochSecond(nbf), ZoneOffset.UTC));
        }
        return this.notBeforeTime.get();
    }

    public void validate(List<AttestationSigner> signers, AttestationTokenValidationOptions options) {
        if (!options.isValidateToken()) {
            return;
        }
        AttestationSigner signer = this.validateTokenSignature(signers);
        this.validateTokenTimeProperties(options);
        this.validateTokenIssuer(options);
        if (options.getValidationCallback() != null) {
            options.getValidationCallback().accept(this, signer);
        }
    }

    private void validateTokenIssuer(AttestationTokenValidationOptions options) {
        if (options.getExpectedIssuer() != null && this.getIssuer() != null && !this.getIssuer().equals(options.getExpectedIssuer())) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("Token Validation Failed due to mismatched issuer. Expected issuer %s, but found %s", options.getExpectedIssuer(), this.getIssuer())));
        }
    }

    private void validateTokenTimeProperties(AttestationTokenValidationOptions options) {
        OffsetDateTime notBefore;
        Duration timeDelta;
        OffsetDateTime expirationTime;
        OffsetDateTime timeNow = OffsetDateTime.now();
        timeNow = timeNow.minusNanos(timeNow.getNano());
        if (this.getExpiresOn() != null && options.isValidateExpiresOn() && timeNow.isAfter(expirationTime = this.getExpiresOn()) && (timeDelta = Duration.between(timeNow, expirationTime)).abs().compareTo(options.getValidationSlack()) > 0) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("Token Validation Failed due to expiration time. Current time: %tc Expiration time: %tc", timeNow, this.getExpiresOn())));
        }
        if (this.getNotBefore() != null && options.isValidateNotBefore() && timeNow.isBefore(notBefore = this.getNotBefore()) && (timeDelta = Duration.between(timeNow, notBefore)).abs().compareTo(options.getValidationSlack()) > 0) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("Token Validation Failed due to NotBefore time. Current time: %tc Token becomes valid at: %tc", timeNow, this.getNotBefore())));
        }
    }

    private AttestationSigner validateTokenSignature(List<AttestationSigner> signers) {
        if (this.getAlgorithm().equals("none")) {
            return null;
        }
        AtomicReference<JWSObject> jwt = new AtomicReference<JWSObject>();
        try {
            jwt.set(JWSObject.parse((String)this.rawToken));
        }
        catch (ParseException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        AtomicReference<AttestationSigner> tokenSigner = new AtomicReference<AttestationSigner>();
        List<AttestationSigner> candidateSigners = this.getCandidateSigners(signers);
        for (AttestationSigner signer : candidateSigners) {
            PublicKey publicKey;
            PublicKey key = signer.getCertificates().get(0).getPublicKey();
            RSASSAVerifier verifier = null;
            if (key instanceof RSAPublicKey) {
                publicKey = (RSAPublicKey)key;
                verifier = new RSASSAVerifier(publicKey);
            } else if (key instanceof ECPublicKey) {
                publicKey = (ECPublicKey)key;
                try {
                    verifier = new ECDSAVerifier((ECPublicKey)publicKey);
                }
                catch (JOSEException e) {
                    throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
                }
            }
            try {
                if (!((JWSObject)jwt.get()).verify((JWSVerifier)verifier)) continue;
                tokenSigner.set(signer);
                break;
            }
            catch (JOSEException e) {
                throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
            }
        }
        return (AttestationSigner)tokenSigner.get();
    }

    private List<AttestationSigner> getCandidateSigners(List<AttestationSigner> signers) {
        ArrayList<AttestationSigner> candidates = new ArrayList<AttestationSigner>();
        String desiredKeyId = this.getKeyId();
        if (desiredKeyId != null && signers != null) {
            signers.forEach(signer -> {
                if (desiredKeyId.equals(signer.getKeyId())) {
                    candidates.add((AttestationSigner)signer);
                }
            });
        }
        if (candidates.size() == 0) {
            if (signers != null && signers.size() != 0) {
                candidates.addAll(signers);
            } else {
                if (this.getCertificateChain() != null) {
                    candidates.add(this.getCertificateChain());
                }
                if (this.getJsonWebKey() != null) {
                    candidates.add(this.getJsonWebKey());
                }
            }
        }
        return candidates;
    }

    public static AttestationToken createUnsecuredToken() {
        return new AttestationTokenImpl(EMPTY_TOKEN);
    }

    public static AttestationToken createUnsecuredToken(String stringBody) {
        Payload payload = new Payload(stringBody);
        PlainObject plainObject = new PlainObject(payload);
        return new AttestationTokenImpl(plainObject.serialize());
    }

    public static AttestationToken createSecuredToken(AttestationSigningKey signingKey) {
        Base64URL signature;
        ECDSASigner signer;
        JWSHeader header;
        block11: {
            ClientLogger logger = new ClientLogger(AttestationTokenImpl.class);
            try {
                signingKey.verify();
            }
            catch (Exception e) {
                throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
            }
            ArrayList<Base64> certs = new ArrayList<Base64>();
            try {
                certs.add(Base64.encode((byte[])signingKey.getCertificate().getEncoded()));
            }
            catch (CertificateEncodingException e) {
                throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
            }
            header = new JWSHeader.Builder(JWSAlgorithm.RS256).x509CertChain(certs).build();
            try {
                if (signingKey.getPrivateKey() instanceof RSAPrivateKey) {
                    HashSet<AllowWeakRSAKey> options = new HashSet<AllowWeakRSAKey>();
                    if (signingKey.isWeakKeyAllowed()) {
                        options.add(AllowWeakRSAKey.getInstance());
                    }
                    signer = new RSASSASigner(signingKey.getPrivateKey(), options);
                    break block11;
                }
                if (signingKey.getPrivateKey() instanceof ECPrivateKey) {
                    signer = new ECDSASigner((ECPrivateKey)signingKey.getPrivateKey());
                    break block11;
                }
                throw new RuntimeException("Assertion failure: Cannot have signer that is not either RSA or EC");
            }
            catch (JOSEException e) {
                throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
            }
        }
        String signedBody = header.toBase64URL() + ".";
        try {
            signature = signer.sign(header, signedBody.getBytes(StandardCharsets.UTF_8));
        }
        catch (JOSEException e) {
            throw new RuntimeException(e.toString());
        }
        return new AttestationTokenImpl(signedBody + "." + signature.toString());
    }

    public static AttestationToken createSecuredToken(String stringBody, AttestationSigningKey signingKey) {
        ClientLogger logger = new ClientLogger(AttestationTokenImpl.class);
        try {
            signingKey.verify();
        }
        catch (Exception e) {
            throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        Payload payload = new Payload(stringBody);
        ArrayList<Base64> certs = new ArrayList<Base64>();
        try {
            certs.add(Base64.encode((byte[])signingKey.getCertificate().getEncoded()));
        }
        catch (CertificateEncodingException e) {
            throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.RS256).x509CertChain(certs).build();
        ECDSASigner signer = null;
        try {
            if (signingKey.getPrivateKey() instanceof RSAPrivateKey) {
                HashSet<AllowWeakRSAKey> options = new HashSet<AllowWeakRSAKey>();
                if (signingKey.isWeakKeyAllowed()) {
                    options.add(AllowWeakRSAKey.getInstance());
                }
                signer = new RSASSASigner(signingKey.getPrivateKey(), options);
            } else if (signingKey.getPrivateKey() instanceof ECPrivateKey) {
                ECPrivateKey privateKey = (ECPrivateKey)signingKey.getPrivateKey();
                signer = new ECDSASigner(privateKey);
            }
        }
        catch (JOSEException e) {
            throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        JWSObject securedObject = new JWSObject(header, payload);
        try {
            securedObject.sign((JWSSigner)signer);
        }
        catch (JOSEException e) {
            throw logger.logExceptionAsError(new RuntimeException(e.toString()));
        }
        return new AttestationTokenImpl(securedObject.serialize());
    }
}

