/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.security.attestation.implementation.models.JsonWebKey;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class AttestationResult {
    @JsonProperty(value="jti")
    private String jti;
    @JsonProperty(value="iss")
    private String iss;
    @JsonProperty(value="iat")
    private Float iat;
    @JsonProperty(value="exp")
    private Float exp;
    @JsonProperty(value="nbf")
    private Float nbf;
    @JsonProperty(value="cnf")
    private Object cnf;
    @JsonProperty(value="nonce")
    private String nonce;
    @JsonProperty(value="x-ms-ver")
    private String version;
    @JsonProperty(value="x-ms-runtime")
    private Object runtimeClaims;
    @JsonProperty(value="x-ms-inittime")
    private Object inittimeClaims;
    @JsonProperty(value="x-ms-policy")
    private Object policyClaims;
    @JsonProperty(value="x-ms-attestation-type")
    private String verifierType;
    @JsonProperty(value="x-ms-policy-signer")
    private JsonWebKey policySigner;
    @JsonProperty(value="x-ms-policy-hash")
    private Base64Url policyHash;
    @JsonProperty(value="x-ms-sgx-is-debuggable")
    private Boolean isDebuggable;
    @JsonProperty(value="x-ms-sgx-product-id")
    private Float productId;
    @JsonProperty(value="x-ms-sgx-mrenclave")
    private String mrEnclave;
    @JsonProperty(value="x-ms-sgx-mrsigner")
    private String mrSigner;
    @JsonProperty(value="x-ms-sgx-svn")
    private Float svn;
    @JsonProperty(value="x-ms-sgx-ehd")
    private Base64Url enclaveHeldData;
    @JsonProperty(value="x-ms-sgx-collateral")
    private Object sgxCollateral;
    @JsonProperty(value="ver")
    private String deprecatedVersion;
    @JsonProperty(value="is-debuggable")
    private Boolean deprecatedIsDebuggable;
    @JsonProperty(value="maa-attestationcollateral")
    private Object deprecatedSgxCollateral;
    @JsonProperty(value="aas-ehd")
    private Base64Url deprecatedEnclaveHeldData;
    @JsonProperty(value="maa-ehd")
    private Base64Url deprecatedEnclaveHeldData2;
    @JsonProperty(value="product-id")
    private Float deprecatedProductId;
    @JsonProperty(value="sgx-mrenclave")
    private String deprecatedMrEnclave;
    @JsonProperty(value="sgx-mrsigner")
    private String deprecatedMrSigner;
    @JsonProperty(value="svn")
    private Float deprecatedSvn;
    @JsonProperty(value="tee")
    private String deprecatedTee;
    @JsonProperty(value="policy_signer")
    private JsonWebKey deprecatedPolicySigner;
    @JsonProperty(value="policy_hash")
    private Base64Url deprecatedPolicyHash;
    @JsonProperty(value="rp_data")
    private String deprecatedRpData;

    public String getJti() {
        return this.jti;
    }

    public AttestationResult setJti(String jti) {
        this.jti = jti;
        return this;
    }

    public String getIss() {
        return this.iss;
    }

    public AttestationResult setIss(String iss) {
        this.iss = iss;
        return this;
    }

    public Float getIat() {
        return this.iat;
    }

    public AttestationResult setIat(Float iat) {
        this.iat = iat;
        return this;
    }

    public Float getExp() {
        return this.exp;
    }

    public AttestationResult setExp(Float exp) {
        this.exp = exp;
        return this;
    }

    public Float getNbf() {
        return this.nbf;
    }

    public AttestationResult setNbf(Float nbf) {
        this.nbf = nbf;
        return this;
    }

    public Object getCnf() {
        return this.cnf;
    }

    public AttestationResult setCnf(Object cnf) {
        this.cnf = cnf;
        return this;
    }

    public String getNonce() {
        return this.nonce;
    }

    public AttestationResult setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public AttestationResult setVersion(String version) {
        this.version = version;
        return this;
    }

    public Object getRuntimeClaims() {
        return this.runtimeClaims;
    }

    public AttestationResult setRuntimeClaims(Object runtimeClaims) {
        this.runtimeClaims = runtimeClaims;
        return this;
    }

    public Object getInittimeClaims() {
        return this.inittimeClaims;
    }

    public AttestationResult setInittimeClaims(Object inittimeClaims) {
        this.inittimeClaims = inittimeClaims;
        return this;
    }

    public Object getPolicyClaims() {
        return this.policyClaims;
    }

    public AttestationResult setPolicyClaims(Object policyClaims) {
        this.policyClaims = policyClaims;
        return this;
    }

    public String getVerifierType() {
        return this.verifierType;
    }

    public AttestationResult setVerifierType(String verifierType) {
        this.verifierType = verifierType;
        return this;
    }

    public JsonWebKey getPolicySigner() {
        return this.policySigner;
    }

    public AttestationResult setPolicySigner(JsonWebKey policySigner) {
        this.policySigner = policySigner;
        return this;
    }

    public byte[] getPolicyHash() {
        if (this.policyHash == null) {
            return new byte[0];
        }
        return this.policyHash.decodedBytes();
    }

    public AttestationResult setPolicyHash(byte[] policyHash) {
        this.policyHash = policyHash == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])policyHash));
        return this;
    }

    public Boolean isDebuggable() {
        return this.isDebuggable;
    }

    public AttestationResult setIsDebuggable(Boolean isDebuggable) {
        this.isDebuggable = isDebuggable;
        return this;
    }

    public Float getProductId() {
        return this.productId;
    }

    public AttestationResult setProductId(Float productId) {
        this.productId = productId;
        return this;
    }

    public String getMrEnclave() {
        return this.mrEnclave;
    }

    public AttestationResult setMrEnclave(String mrEnclave) {
        this.mrEnclave = mrEnclave;
        return this;
    }

    public String getMrSigner() {
        return this.mrSigner;
    }

    public AttestationResult setMrSigner(String mrSigner) {
        this.mrSigner = mrSigner;
        return this;
    }

    public Float getSvn() {
        return this.svn;
    }

    public AttestationResult setSvn(Float svn) {
        this.svn = svn;
        return this;
    }

    public byte[] getEnclaveHeldData() {
        if (this.enclaveHeldData == null) {
            return new byte[0];
        }
        return this.enclaveHeldData.decodedBytes();
    }

    public AttestationResult setEnclaveHeldData(byte[] enclaveHeldData) {
        this.enclaveHeldData = enclaveHeldData == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])enclaveHeldData));
        return this;
    }

    public Object getSgxCollateral() {
        return this.sgxCollateral;
    }

    public AttestationResult setSgxCollateral(Object sgxCollateral) {
        this.sgxCollateral = sgxCollateral;
        return this;
    }

    public String getDeprecatedVersion() {
        return this.deprecatedVersion;
    }

    public AttestationResult setDeprecatedVersion(String deprecatedVersion) {
        this.deprecatedVersion = deprecatedVersion;
        return this;
    }

    public Boolean isDeprecatedIsDebuggable() {
        return this.deprecatedIsDebuggable;
    }

    public AttestationResult setDeprecatedIsDebuggable(Boolean deprecatedIsDebuggable) {
        this.deprecatedIsDebuggable = deprecatedIsDebuggable;
        return this;
    }

    public Object getDeprecatedSgxCollateral() {
        return this.deprecatedSgxCollateral;
    }

    public AttestationResult setDeprecatedSgxCollateral(Object deprecatedSgxCollateral) {
        this.deprecatedSgxCollateral = deprecatedSgxCollateral;
        return this;
    }

    public byte[] getDeprecatedEnclaveHeldData() {
        if (this.deprecatedEnclaveHeldData == null) {
            return new byte[0];
        }
        return this.deprecatedEnclaveHeldData.decodedBytes();
    }

    public AttestationResult setDeprecatedEnclaveHeldData(byte[] deprecatedEnclaveHeldData) {
        this.deprecatedEnclaveHeldData = deprecatedEnclaveHeldData == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])deprecatedEnclaveHeldData));
        return this;
    }

    public byte[] getDeprecatedEnclaveHeldData2() {
        if (this.deprecatedEnclaveHeldData2 == null) {
            return new byte[0];
        }
        return this.deprecatedEnclaveHeldData2.decodedBytes();
    }

    public AttestationResult setDeprecatedEnclaveHeldData2(byte[] deprecatedEnclaveHeldData2) {
        this.deprecatedEnclaveHeldData2 = deprecatedEnclaveHeldData2 == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])deprecatedEnclaveHeldData2));
        return this;
    }

    public Float getDeprecatedProductId() {
        return this.deprecatedProductId;
    }

    public AttestationResult setDeprecatedProductId(Float deprecatedProductId) {
        this.deprecatedProductId = deprecatedProductId;
        return this;
    }

    public String getDeprecatedMrEnclave() {
        return this.deprecatedMrEnclave;
    }

    public AttestationResult setDeprecatedMrEnclave(String deprecatedMrEnclave) {
        this.deprecatedMrEnclave = deprecatedMrEnclave;
        return this;
    }

    public String getDeprecatedMrSigner() {
        return this.deprecatedMrSigner;
    }

    public AttestationResult setDeprecatedMrSigner(String deprecatedMrSigner) {
        this.deprecatedMrSigner = deprecatedMrSigner;
        return this;
    }

    public Float getDeprecatedSvn() {
        return this.deprecatedSvn;
    }

    public AttestationResult setDeprecatedSvn(Float deprecatedSvn) {
        this.deprecatedSvn = deprecatedSvn;
        return this;
    }

    public String getDeprecatedTee() {
        return this.deprecatedTee;
    }

    public AttestationResult setDeprecatedTee(String deprecatedTee) {
        this.deprecatedTee = deprecatedTee;
        return this;
    }

    public JsonWebKey getDeprecatedPolicySigner() {
        return this.deprecatedPolicySigner;
    }

    public AttestationResult setDeprecatedPolicySigner(JsonWebKey deprecatedPolicySigner) {
        this.deprecatedPolicySigner = deprecatedPolicySigner;
        return this;
    }

    public byte[] getDeprecatedPolicyHash() {
        if (this.deprecatedPolicyHash == null) {
            return new byte[0];
        }
        return this.deprecatedPolicyHash.decodedBytes();
    }

    public AttestationResult setDeprecatedPolicyHash(byte[] deprecatedPolicyHash) {
        this.deprecatedPolicyHash = deprecatedPolicyHash == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])deprecatedPolicyHash));
        return this;
    }

    public String getDeprecatedRpData() {
        return this.deprecatedRpData;
    }

    public AttestationResult setDeprecatedRpData(String deprecatedRpData) {
        this.deprecatedRpData = deprecatedRpData;
        return this;
    }

    public void validate() {
        if (this.getPolicySigner() != null) {
            this.getPolicySigner().validate();
        }
        if (this.getDeprecatedPolicySigner() != null) {
            this.getDeprecatedPolicySigner().validate();
        }
    }
}

