/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation.models;

import com.azure.security.attestation.implementation.models.AttestOpenEnclaveRequest;
import com.azure.security.attestation.implementation.models.AttestSgxEnclaveRequest;
import com.azure.security.attestation.implementation.models.DataType;
import com.azure.security.attestation.implementation.models.InitTimeData;
import com.azure.security.attestation.implementation.models.RuntimeData;
import com.azure.security.attestation.models.AttestationOptions;

public final class AttestationOptionsImpl {
    private final AttestationOptions options;

    public AttestationOptionsImpl(AttestationOptions options) {
        this.options = options;
    }

    public AttestOpenEnclaveRequest getInternalAttestOpenEnclaveRequest() {
        return new AttestOpenEnclaveRequest().setDraftPolicyForAttestation(this.options.getDraftPolicyForAttestation()).setRuntimeData(this.options.getRunTimeData() != null ? new RuntimeData().setData(this.options.getRunTimeData().getData().toBytes()).setDataType(DataType.fromString(this.options.getRunTimeData().getInterpretation().toString())) : null).setInitTimeData(this.options.getInitTimeData() != null ? new InitTimeData().setData(this.options.getInitTimeData().getData().toBytes()).setDataType(DataType.fromString(this.options.getInitTimeData().getInterpretation().toString())) : null).setReport(this.options.getEvidence().toBytes());
    }

    public AttestSgxEnclaveRequest getInternalAttestSgxRequest() {
        return new AttestSgxEnclaveRequest().setDraftPolicyForAttestation(this.options.getDraftPolicyForAttestation()).setRuntimeData(this.options.getRunTimeData() != null ? new RuntimeData().setData(this.options.getRunTimeData().getData().toBytes()).setDataType(DataType.fromString(this.options.getRunTimeData().getInterpretation().toString())) : null).setInitTimeData(this.options.getInitTimeData() != null ? new InitTimeData().setData(this.options.getInitTimeData().getData().toBytes()).setDataType(DataType.fromString(this.options.getInitTimeData().getInterpretation().toString())) : null).setQuote(this.options.getEvidence().toBytes());
    }
}

