/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.attestation.implementation.AttestationClientImpl;
import com.azure.security.attestation.implementation.models.CloudErrorException;
import reactor.core.publisher.Mono;

public final class MetadataConfigurationsImpl {
    private final MetadataConfigurationsService service;
    private final AttestationClientImpl client;

    MetadataConfigurationsImpl(AttestationClientImpl client) {
        this.service = (MetadataConfigurationsService)RestProxy.create(MetadataConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> getWithResponseAsync(Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.get(this.client.getInstanceUrl(), "application/json", context);
    }

    @Host(value="{instanceUrl}")
    @ServiceInterface(name="AttestationClientMet")
    public static interface MetadataConfigurationsService {
        @Get(value="/.well-known/openid-configuration")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Object>> get(@HostParam(value="instanceUrl") String var1, @HeaderParam(value="Accept") String var2, Context var3);
    }
}

