/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.attestation.AttestationClientBuilder;
import com.azure.security.attestation.Utilities;
import com.azure.security.attestation.implementation.AttestationClientImpl;
import com.azure.security.attestation.implementation.AttestationsImpl;
import com.azure.security.attestation.implementation.MetadataConfigurationsImpl;
import com.azure.security.attestation.implementation.SigningCertificatesImpl;
import com.azure.security.attestation.implementation.models.AttestationOpenIdMetadataImpl;
import com.azure.security.attestation.implementation.models.AttestationOptionsImpl;
import com.azure.security.attestation.implementation.models.AttestationResultImpl;
import com.azure.security.attestation.implementation.models.AttestationSignerCollectionImpl;
import com.azure.security.attestation.implementation.models.AttestationSignerImpl;
import com.azure.security.attestation.implementation.models.AttestationTokenImpl;
import com.azure.security.attestation.implementation.models.JsonWebKeySet;
import com.azure.security.attestation.implementation.models.TpmAttestationRequest;
import com.azure.security.attestation.implementation.models.TpmAttestationResponse;
import com.azure.security.attestation.models.AttestationOpenIdMetadata;
import com.azure.security.attestation.models.AttestationOptions;
import com.azure.security.attestation.models.AttestationResponse;
import com.azure.security.attestation.models.AttestationResult;
import com.azure.security.attestation.models.AttestationSigner;
import com.azure.security.attestation.models.AttestationSignerCollection;
import com.azure.security.attestation.models.AttestationToken;
import com.azure.security.attestation.models.AttestationTokenValidationOptions;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AttestationClientBuilder.class, isAsync=true)
public final class AttestationAsyncClient {
    private final AttestationsImpl attestImpl;
    private final MetadataConfigurationsImpl metadataImpl;
    private final SigningCertificatesImpl signerImpl;
    private final ClientLogger logger;
    private final AttestationTokenValidationOptions tokenValidationOptions;
    private final AtomicReference<List<AttestationSigner>> cachedSigners;

    AttestationAsyncClient(AttestationClientImpl clientImpl, AttestationTokenValidationOptions tokenValidationOptions) {
        this.attestImpl = clientImpl.getAttestations();
        this.metadataImpl = clientImpl.getMetadataConfigurations();
        this.signerImpl = clientImpl.getSigningCertificates();
        this.tokenValidationOptions = tokenValidationOptions;
        this.logger = new ClientLogger(AttestationAsyncClient.class);
        this.cachedSigners = new AtomicReference<Object>(null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AttestationOpenIdMetadata>> getOpenIdMetadataWithResponse() {
        return FluxUtil.withContext(context -> this.getOpenIdMetadataWithResponse((Context)context));
    }

    Mono<Response<AttestationOpenIdMetadata>> getOpenIdMetadataWithResponse(Context context) {
        return this.metadataImpl.getWithResponseAsync(context).map(generated -> Utilities.generateResponseFromModelType(generated, AttestationOpenIdMetadataImpl.fromGenerated(generated.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationOpenIdMetadata> getOpenIdMetadata() {
        return this.getOpenIdMetadataWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationSignerCollection> listAttestationSigners() {
        return this.listAttestationSignersWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AttestationSignerCollection>> listAttestationSignersWithResponse() {
        return FluxUtil.withContext(context -> this.listAttestationSignersWithResponse((Context)context));
    }

    Mono<Response<AttestationSignerCollection>> listAttestationSignersWithResponse(Context context) {
        return this.signerImpl.getWithResponseAsync(context).map(response -> Utilities.generateResponseFromModelType(response, new AttestationSignerCollectionImpl(AttestationSignerImpl.attestationSignersFromJwks((JsonWebKeySet)response.getValue()))));
    }

    Mono<List<AttestationSigner>> getCachedAttestationSigners(Context context) {
        if (this.cachedSigners.get() != null) {
            return Mono.just(this.cachedSigners.get());
        }
        return this.signerImpl.getWithResponseAsync(context).map(response -> AttestationSignerImpl.attestationSignersFromJwks((JsonWebKeySet)response.getValue())).map(signers -> {
            this.cachedSigners.compareAndSet((List<AttestationSigner>)null, (List<AttestationSigner>)signers);
            return this.cachedSigners.get();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResult> attestOpenEnclave(BinaryData report) {
        return this.attestOpenEnclaveWithResponse(new AttestationOptions(report)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResponse<AttestationResult>> attestOpenEnclaveWithResponse(AttestationOptions options) {
        return FluxUtil.withContext(context -> this.attestOpenEnclaveWithResponse(options, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResult> attestOpenEnclave(AttestationOptions options) {
        return this.attestOpenEnclaveWithResponse(options).flatMap(FluxUtil::toMono);
    }

    Mono<AttestationResponse<AttestationResult>> attestOpenEnclaveWithResponse(AttestationOptions options, Context context) {
        AttestationOptionsImpl optionsImpl = new AttestationOptionsImpl(options);
        AttestationTokenValidationOptions validationOptions = options.getValidationOptions();
        if (validationOptions == null) {
            validationOptions = this.tokenValidationOptions;
        }
        AttestationTokenValidationOptions finalValidationOptions = validationOptions;
        return this.attestImpl.attestOpenEnclaveWithResponseAsync(optionsImpl.getInternalAttestOpenEnclaveRequest(), context).onErrorMap(Utilities::mapException).map(response -> Utilities.generateResponseFromModelType(response, new AttestationTokenImpl(((com.azure.security.attestation.implementation.models.AttestationResponse)response.getValue()).getToken()))).flatMap(response -> {
            if (finalValidationOptions.isValidateToken()) {
                return this.getCachedAttestationSigners(context).map(signers -> {
                    ((AttestationTokenImpl)response.getValue()).validate((List<AttestationSigner>)signers, finalValidationOptions);
                    return response;
                });
            }
            return Mono.just((Object)response);
        }).map(response -> {
            com.azure.security.attestation.implementation.models.AttestationResult generatedResult = ((AttestationTokenImpl)response.getValue()).getBody(com.azure.security.attestation.implementation.models.AttestationResult.class);
            return Utilities.generateAttestationResponseFromModelType(response, (AttestationToken)response.getValue(), AttestationResultImpl.fromGeneratedAttestationResult(generatedResult));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResult> attestSgxEnclave(BinaryData quote) {
        return this.attestSgxEnclaveWithResponse(new AttestationOptions(quote)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResponse<AttestationResult>> attestSgxEnclaveWithResponse(AttestationOptions options) {
        return FluxUtil.withContext(context -> this.attestSgxEnclaveWithResponse(options, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResult> attestSgxEnclave(AttestationOptions options) {
        return this.attestSgxEnclaveWithResponse(options).flatMap(FluxUtil::toMono);
    }

    Mono<AttestationResponse<AttestationResult>> attestSgxEnclaveWithResponse(AttestationOptions options, Context context) {
        AttestationOptionsImpl optionsImpl = new AttestationOptionsImpl(options);
        AttestationTokenValidationOptions validationOptions = options.getValidationOptions();
        if (validationOptions == null) {
            validationOptions = this.tokenValidationOptions;
        }
        AttestationTokenValidationOptions finalValidationOptions = validationOptions;
        return this.attestImpl.attestSgxEnclaveWithResponseAsync(optionsImpl.getInternalAttestSgxRequest(), context).onErrorMap(Utilities::mapException).map(response -> Utilities.generateResponseFromModelType(response, new AttestationTokenImpl(((com.azure.security.attestation.implementation.models.AttestationResponse)response.getValue()).getToken()))).flatMap(response -> {
            if (finalValidationOptions.isValidateToken()) {
                return this.getCachedAttestationSigners(context).map(signers -> {
                    ((AttestationTokenImpl)response.getValue()).validate((List<AttestationSigner>)signers, finalValidationOptions);
                    return response;
                });
            }
            return Mono.just((Object)response);
        }).map(response -> {
            com.azure.security.attestation.implementation.models.AttestationResult generatedResult = ((AttestationTokenImpl)response.getValue()).getBody(com.azure.security.attestation.implementation.models.AttestationResult.class);
            return Utilities.generateAttestationResponseFromModelType(response, (AttestationToken)response.getValue(), AttestationResultImpl.fromGeneratedAttestationResult(generatedResult));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> attestTpmWithResponse(String request) {
        return FluxUtil.withContext(context -> this.attestTpmWithResponse(request, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> attestTpm(String request) {
        return this.attestTpmWithResponse(request).onErrorMap(Utilities::mapException).flatMap(FluxUtil::toMono);
    }

    Mono<Response<String>> attestTpmWithResponse(String request, Context context) {
        Objects.requireNonNull(request);
        return this.attestImpl.attestTpmWithResponseAsync(new TpmAttestationRequest().setData(request.getBytes(StandardCharsets.UTF_8)), context).map(response -> Utilities.generateResponseFromModelType(response, new String(Objects.requireNonNull(((TpmAttestationResponse)response.getValue()).getData()), StandardCharsets.UTF_8)));
    }
}

