/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.attestation.implementation.AttestationsImpl;
import com.azure.security.attestation.implementation.MetadataConfigurationsImpl;
import com.azure.security.attestation.implementation.PoliciesImpl;
import com.azure.security.attestation.implementation.PolicyCertificatesImpl;
import com.azure.security.attestation.implementation.SigningCertificatesImpl;

public final class AttestationClientImpl {
    private final String instanceUrl;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final PoliciesImpl policies;
    private final PolicyCertificatesImpl policyCertificates;
    private final AttestationsImpl attestations;
    private final SigningCertificatesImpl signingCertificates;
    private final MetadataConfigurationsImpl metadataConfigurations;

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public PoliciesImpl getPolicies() {
        return this.policies;
    }

    public PolicyCertificatesImpl getPolicyCertificates() {
        return this.policyCertificates;
    }

    public AttestationsImpl getAttestations() {
        return this.attestations;
    }

    public SigningCertificatesImpl getSigningCertificates() {
        return this.signingCertificates;
    }

    public MetadataConfigurationsImpl getMetadataConfigurations() {
        return this.metadataConfigurations;
    }

    public AttestationClientImpl(String instanceUrl, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), instanceUrl, apiVersion);
    }

    public AttestationClientImpl(HttpPipeline httpPipeline, String instanceUrl, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), instanceUrl, apiVersion);
    }

    public AttestationClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String instanceUrl, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.instanceUrl = instanceUrl;
        this.apiVersion = apiVersion;
        this.policies = new PoliciesImpl(this);
        this.policyCertificates = new PolicyCertificatesImpl(this);
        this.attestations = new AttestationsImpl(this);
        this.signingCertificates = new SigningCertificatesImpl(this);
        this.metadataConfigurations = new MetadataConfigurationsImpl(this);
    }
}

