/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.models;

import com.azure.core.util.BinaryData;
import com.azure.security.attestation.models.AttestationData;
import com.azure.security.attestation.models.AttestationTokenValidationOptions;

public final class AttestationOptions {
    private final BinaryData evidence;
    private AttestationData runTimeData;
    private AttestationData initTimeData;
    private String draftPolicyForAttestation;
    private AttestationTokenValidationOptions validationOptions;

    public AttestationOptions(BinaryData evidence) {
        this.evidence = evidence;
    }

    public BinaryData getEvidence() {
        return this.evidence;
    }

    public AttestationOptions setRunTimeData(AttestationData attestationData) {
        this.runTimeData = attestationData;
        return this;
    }

    public AttestationData getRunTimeData() {
        return this.runTimeData != null ? new AttestationData(this.runTimeData) : null;
    }

    public AttestationOptions setInitTimeData(AttestationData attestationData) {
        this.initTimeData = attestationData;
        return this;
    }

    public AttestationData getInitTimeData() {
        return this.initTimeData != null ? new AttestationData(this.initTimeData) : null;
    }

    public AttestationOptions setDraftPolicyForAttestation(String draftPolicyForAttestation) {
        this.draftPolicyForAttestation = draftPolicyForAttestation;
        return this;
    }

    public String getDraftPolicyForAttestation() {
        return this.draftPolicyForAttestation;
    }

    public AttestationOptions setValidationOptions(AttestationTokenValidationOptions validationOptions) {
        this.validationOptions = validationOptions;
        return this;
    }

    public AttestationTokenValidationOptions getValidationOptions() {
        return this.validationOptions;
    }
}

