/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation.models;

import com.azure.core.util.Base64Util;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.attestation.implementation.models.JsonWebKey;
import com.azure.security.attestation.implementation.models.JsonWebKeySet;
import com.azure.security.attestation.models.AttestationSigner;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AttestationSignerImpl
implements AttestationSigner {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private List<X509Certificate> certificates;
    private String keyId;

    AttestationSignerImpl setCertificates(X509Certificate[] certificates) {
        this.certificates = this.cloneX509CertificateChain(certificates);
        return this;
    }

    private List<X509Certificate> cloneX509CertificateChain(X509Certificate[] certificates) {
        ClientLogger logger = new ClientLogger(AttestationSignerImpl.class);
        return Arrays.stream(certificates).map(certificate -> {
            X509Certificate newCert;
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                newCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificate.getEncoded()));
            }
            catch (CertificateException e) {
                throw logger.logExceptionAsError(new RuntimeException(e));
            }
            return newCert;
        }).collect(Collectors.toList());
    }

    AttestationSignerImpl setKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    @Override
    public final List<X509Certificate> getCertificates() {
        return this.cloneX509CertificateChain(this.certificates.toArray(new X509Certificate[0]));
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    @Override
    public void validate() {
        Objects.requireNonNull(this.certificates);
        for (X509Certificate certificate : this.certificates) {
            Objects.requireNonNull(certificate);
        }
    }

    public static AttestationSigner fromCertificateChain(List<Base64> certificateChain) {
        X509Certificate[] certChain = (X509Certificate[])certificateChain.stream().map(AttestationSignerImpl::certificateFromBase64).toArray(X509Certificate[]::new);
        return new AttestationSignerImpl().setCertificates(certChain);
    }

    public static AttestationSigner fromJWK(JWK jwk) throws Error {
        JsonWebKey jsonWebKey;
        ClientLogger logger = new ClientLogger(AttestationSignerImpl.class);
        String serializedKey = jwk.toJSONString();
        try {
            jsonWebKey = (JsonWebKey)MAPPER.readValue(serializedKey, JsonWebKey.class);
        }
        catch (JsonProcessingException e) {
            throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        return AttestationSignerImpl.fromJsonWebKey(jsonWebKey);
    }

    public static AttestationSigner fromJsonWebKey(JsonWebKey jsonWebKey) {
        List<String> certificateChain = jsonWebKey.getX5C();
        if (certificateChain != null) {
            X509Certificate[] certificateArray = (X509Certificate[])certificateChain.stream().map(AttestationSignerImpl::certificateFromBase64String).toArray(X509Certificate[]::new);
            return new AttestationSignerImpl().setCertificates(certificateArray).setKeyId(jsonWebKey.getKid());
        }
        throw new Error("Could not resolve AttestationSigner from JWK.");
    }

    public static List<AttestationSigner> attestationSignersFromJwks(JsonWebKeySet jwks) {
        return jwks.getKeys().stream().map(AttestationSignerImpl::fromJsonWebKey).collect(Collectors.toList());
    }

    static X509Certificate certificateFromBase64(Base64 base64certificate) {
        return AttestationSignerImpl.certificateFromBase64String(base64certificate.toString());
    }

    static X509Certificate certificateFromBase64String(String base64certificate) {
        Certificate cert;
        CertificateFactory cf;
        ClientLogger logger = new ClientLogger(AttestationSignerImpl.class);
        byte[] decodedCertificate = Base64Util.decodeString((String)base64certificate);
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        try {
            cert = cf.generateCertificate(new ByteArrayInputStream(decodedCertificate));
        }
        catch (CertificateException e) {
            throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        return (X509Certificate)cert;
    }
}

