/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.security.attestation.implementation.models.InitTimeData;
import com.azure.security.attestation.implementation.models.RuntimeData;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class AttestOpenEnclaveRequest {
    @JsonProperty(value="report")
    private Base64Url report;
    @JsonProperty(value="runtimeData")
    private RuntimeData runtimeData;
    @JsonProperty(value="initTimeData")
    private InitTimeData initTimeData;
    @JsonProperty(value="draftPolicyForAttestation")
    private String draftPolicyForAttestation;

    public byte[] getReport() {
        if (this.report == null) {
            return new byte[0];
        }
        return this.report.decodedBytes();
    }

    public AttestOpenEnclaveRequest setReport(byte[] report) {
        this.report = report == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])report));
        return this;
    }

    public RuntimeData getRuntimeData() {
        return this.runtimeData;
    }

    public AttestOpenEnclaveRequest setRuntimeData(RuntimeData runtimeData) {
        this.runtimeData = runtimeData;
        return this;
    }

    public InitTimeData getInitTimeData() {
        return this.initTimeData;
    }

    public AttestOpenEnclaveRequest setInitTimeData(InitTimeData initTimeData) {
        this.initTimeData = initTimeData;
        return this;
    }

    public String getDraftPolicyForAttestation() {
        return this.draftPolicyForAttestation;
    }

    public AttestOpenEnclaveRequest setDraftPolicyForAttestation(String draftPolicyForAttestation) {
        this.draftPolicyForAttestation = draftPolicyForAttestation;
        return this;
    }

    public void validate() {
        if (this.getRuntimeData() != null) {
            this.getRuntimeData().validate();
        }
        if (this.getInitTimeData() != null) {
            this.getInitTimeData().validate();
        }
    }
}

