/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.attestation.implementation.AttestationClientImpl;
import com.azure.security.attestation.implementation.models.CloudErrorException;
import com.azure.security.attestation.implementation.models.PolicyResponse;
import com.azure.security.attestation.models.AttestationType;
import reactor.core.publisher.Mono;

public final class PoliciesImpl {
    private final PoliciesService service;
    private final AttestationClientImpl client;

    PoliciesImpl(AttestationClientImpl client) {
        this.service = (PoliciesService)RestProxy.create(PoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyResponse>> getWithResponseAsync(AttestationType attestationType, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (attestationType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationType is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.get(this.client.getInstanceUrl(), this.client.getApiVersion(), attestationType, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyResponse>> setWithResponseAsync(AttestationType attestationType, String newAttestationPolicy, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (attestationType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationType is required and cannot be null."));
        }
        if (newAttestationPolicy == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter newAttestationPolicy is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.set(this.client.getInstanceUrl(), this.client.getApiVersion(), attestationType, newAttestationPolicy, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyResponse>> resetWithResponseAsync(AttestationType attestationType, String policyJws, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (attestationType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter attestationType is required and cannot be null."));
        }
        if (policyJws == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyJws is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.reset(this.client.getInstanceUrl(), this.client.getApiVersion(), attestationType, policyJws, "application/json", context);
    }

    @Host(value="{instanceUrl}")
    @ServiceInterface(name="AttestationClientPol")
    public static interface PoliciesService {
        @Get(value="/policies/{attestationType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<PolicyResponse>> get(@HostParam(value="instanceUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="attestationType") AttestationType var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/policies/{attestationType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<PolicyResponse>> set(@HostParam(value="instanceUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="attestationType") AttestationType var3, @BodyParam(value="text/plain") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/policies/{attestationType}:reset")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<PolicyResponse>> reset(@HostParam(value="instanceUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="attestationType") AttestationType var3, @BodyParam(value="text/plain") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

