/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.models;

import com.azure.core.util.logging.ClientLogger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Objects;

public final class AttestationSigningKey {
    private boolean weakKeyAllowed;
    private final X509Certificate certificate;
    private final PrivateKey privateKey;

    public AttestationSigningKey(X509Certificate certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.weakKeyAllowed = false;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public AttestationSigningKey setWeakKeyAllowed(boolean weakKeyAllowed) {
        this.weakKeyAllowed = weakKeyAllowed;
        return this;
    }

    public boolean isWeakKeyAllowed() {
        return this.weakKeyAllowed;
    }

    public void verify() {
        Objects.requireNonNull(this.certificate);
        Objects.requireNonNull(this.privateKey);
        try {
            Signature verifier;
            Signature signer;
            if (this.privateKey instanceof RSAPrivateKey) {
                signer = Signature.getInstance("SHA256WITHRSA");
                verifier = Signature.getInstance("SHA256WITHRSA");
            } else if (this.privateKey instanceof ECPrivateKey) {
                signer = Signature.getInstance("SHA256WITHECDSA");
                verifier = Signature.getInstance("SHA256WITHECDSA");
            } else {
                ClientLogger logger = new ClientLogger(AttestationSigningKey.class);
                throw logger.logExceptionAsError((RuntimeException)new InvalidParameterException("AttestationSigningKey privateKey must be an RSA or DSA private key"));
            }
            byte[] bufferToSign = new byte[]{1, 2, 3, 4, 5};
            signer.initSign(this.privateKey);
            signer.update(bufferToSign);
            byte[] signedBuffer = signer.sign();
            verifier.initVerify(this.certificate);
            verifier.update(bufferToSign);
            if (!verifier.verify(signedBuffer)) {
                ClientLogger logger = new ClientLogger(AttestationSigningKey.class);
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("AttestationSigningKey certificate cannot verify buffer signed with AttestationSigningKey key"));
            }
        }
        catch (NoSuchAlgorithmException e) {
            ClientLogger logger = new ClientLogger(AttestationSigningKey.class);
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("AttestationSigningKey certificate cannot verify buffer signed with AttestationSigningKey key", e));
        }
        catch (InvalidKeyException e) {
            ClientLogger logger = new ClientLogger(AttestationSigningKey.class);
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("AttestationSigningKey certificate cannot verify buffer signed with AttestationSigningKey key", e));
        }
        catch (SignatureException e) {
            ClientLogger logger = new ClientLogger(AttestationSigningKey.class);
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("AttestationSigningKey certificate cannot verify buffer signed with AttestationSigningKey key", e));
        }
    }
}

