/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation.models;

import com.azure.core.util.BinaryData;
import com.azure.security.attestation.implementation.models.AttestationSignerImpl;
import com.azure.security.attestation.implementation.models.JsonWebKey;
import com.azure.security.attestation.implementation.models.PolicyResult;
import com.azure.security.attestation.models.AttestationSigner;
import com.azure.security.attestation.models.PolicyModification;

public final class PolicyResultImpl
implements com.azure.security.attestation.models.PolicyResult {
    private final PolicyModification policyResolution;
    private final BinaryData policyTokenHash;
    private final AttestationSigner policySigner;

    @Override
    public PolicyModification getPolicyResolution() {
        return this.policyResolution;
    }

    @Override
    public BinaryData getPolicyTokenHash() {
        return this.policyTokenHash;
    }

    @Override
    public AttestationSigner getPolicySigner() {
        return this.policySigner;
    }

    private PolicyResultImpl(JsonWebKey signer, PolicyModification resolution, byte[] policyTokenHash) {
        this.policySigner = signer != null ? AttestationSignerImpl.fromJsonWebKey(signer) : null;
        this.policyTokenHash = policyTokenHash != null ? BinaryData.fromBytes((byte[])policyTokenHash) : null;
        this.policyResolution = resolution;
    }

    public static com.azure.security.attestation.models.PolicyResult fromGenerated(PolicyResult generated) {
        return new PolicyResultImpl(generated.getPolicySigner(), generated.getPolicyResolution(), generated.getPolicyTokenHash());
    }
}

