/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.security.attestation.implementation.models.JsonWebKey;
import com.azure.security.attestation.models.PolicyModification;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class PolicyResult {
    @JsonProperty(value="x-ms-policy-result")
    private PolicyModification policyResolution;
    @JsonProperty(value="x-ms-policy-token-hash")
    private Base64Url policyTokenHash;
    @JsonProperty(value="x-ms-policy-signer")
    private JsonWebKey policySigner;
    @JsonProperty(value="x-ms-policy")
    private String policy;

    public PolicyModification getPolicyResolution() {
        return this.policyResolution;
    }

    public PolicyResult setPolicyResolution(PolicyModification policyResolution) {
        this.policyResolution = policyResolution;
        return this;
    }

    public byte[] getPolicyTokenHash() {
        if (this.policyTokenHash == null) {
            return new byte[0];
        }
        return this.policyTokenHash.decodedBytes();
    }

    public PolicyResult setPolicyTokenHash(byte[] policyTokenHash) {
        this.policyTokenHash = policyTokenHash == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])policyTokenHash));
        return this;
    }

    public JsonWebKey getPolicySigner() {
        return this.policySigner;
    }

    public PolicyResult setPolicySigner(JsonWebKey policySigner) {
        this.policySigner = policySigner;
        return this;
    }

    public String getPolicy() {
        return this.policy;
    }

    public PolicyResult setPolicy(String policy) {
        this.policy = policy;
        return this;
    }

    public void validate() {
        if (this.getPolicySigner() != null) {
            this.getPolicySigner().validate();
        }
    }
}

