/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation.models;

import com.azure.core.util.BinaryData;
import com.azure.security.attestation.implementation.models.AttestationResult;
import com.azure.security.attestation.implementation.models.AttestationSignerImpl;
import com.azure.security.attestation.models.AttestationSigner;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class AttestationResultImpl
implements com.azure.security.attestation.models.AttestationResult {
    private String jti;
    private String iss;
    private OffsetDateTime iat;
    private OffsetDateTime exp;
    private OffsetDateTime nbf;
    private String nonce;
    private String version;
    private Object runtimeClaims;
    private Object inittimeClaims;
    private Object policyClaims;
    private String verifierType;
    private AttestationSigner policySigner;
    private byte[] policyHash;
    private Boolean isDebuggable;
    private int productId;
    private String mrEnclave;
    private String mrSigner;
    private int svn;
    private byte[] enclaveHeldData;
    private Object sgxCollateral;

    @Override
    public String getUniqueIdentifier() {
        return this.jti;
    }

    @Override
    public String getIssuer() {
        return this.iss;
    }

    @Override
    public OffsetDateTime getIssuedAt() {
        return this.iat;
    }

    @Override
    public OffsetDateTime getExpiresOn() {
        return this.exp;
    }

    @Override
    public OffsetDateTime getNotBefore() {
        return this.nbf;
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Object getRuntimeClaims() {
        return this.runtimeClaims;
    }

    @Override
    public Object getInitTimeClaims() {
        return this.inittimeClaims;
    }

    @Override
    public Object getPolicyClaims() {
        return this.policyClaims;
    }

    @Override
    public String getVerifierType() {
        return this.verifierType;
    }

    @Override
    public AttestationSigner getPolicySigner() {
        return this.policySigner;
    }

    @Override
    public BinaryData getPolicyHash() {
        return BinaryData.fromBytes((byte[])this.policyHash);
    }

    @Override
    public Boolean isDebuggable() {
        return this.isDebuggable;
    }

    @Override
    public int getProductId() {
        return this.productId;
    }

    @Override
    public String getMrEnclave() {
        return this.mrEnclave;
    }

    @Override
    public String getMrSigner() {
        return this.mrSigner;
    }

    @Override
    public int getSvn() {
        return this.svn;
    }

    @Override
    public BinaryData getEnclaveHeldData() {
        return BinaryData.fromBytes((byte[])this.enclaveHeldData);
    }

    @Override
    public Object getSgxCollateral() {
        return this.sgxCollateral;
    }

    public static com.azure.security.attestation.models.AttestationResult fromGeneratedAttestationResult(AttestationResult generated) {
        AttestationResultImpl result = new AttestationResultImpl();
        result.enclaveHeldData = generated.getEnclaveHeldData();
        result.inittimeClaims = generated.getInittimeClaims();
        result.runtimeClaims = generated.getRuntimeClaims();
        result.policyClaims = generated.getPolicyClaims();
        result.verifierType = generated.getVerifierType();
        result.nonce = generated.getNonce();
        result.version = generated.getVersion();
        result.iss = generated.getIss();
        result.jti = generated.getJti();
        result.exp = OffsetDateTime.ofInstant(Instant.ofEpochSecond(generated.getExp().longValue()), ZoneOffset.UTC);
        result.iat = OffsetDateTime.ofInstant(Instant.ofEpochSecond(generated.getIat().longValue()), ZoneOffset.UTC);
        result.nbf = OffsetDateTime.ofInstant(Instant.ofEpochSecond(generated.getNbf().longValue()), ZoneOffset.UTC);
        result.mrEnclave = generated.getMrEnclave();
        result.mrSigner = generated.getMrSigner();
        result.isDebuggable = generated.isDebuggable();
        result.policyHash = generated.getPolicyHash();
        if (generated.getPolicySigner() != null) {
            result.policySigner = AttestationSignerImpl.fromJsonWebKey(generated.getPolicySigner());
        }
        result.sgxCollateral = generated.getSgxCollateral();
        result.svn = generated.getSvn().intValue();
        result.productId = generated.getProductId().intValue();
        return result;
    }
}

