/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.security.attestation.models.AttestationOpenIdMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class AttestationOpenIdMetadataImpl
implements AttestationOpenIdMetadata {
    @JsonProperty(value="jwks_uri")
    private String jwksUri;
    @JsonProperty(value="issuer")
    private String issuer;
    @JsonProperty(value="response_types_supported")
    private String[] responseTypesSupported;
    @JsonProperty(value="id_token_signing_alg_values_supported")
    private String[] tokenSigningAlgorithmsSupported;
    @JsonProperty(value="claims_supported")
    private String[] supportedClaims;

    @Override
    public String getJsonWebKeySetUrl() {
        return this.jwksUri;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String[] getResponseTypesSupported() {
        return (String[])this.responseTypesSupported.clone();
    }

    @Override
    public String[] getTokenSigningAlgorithmsSupported() {
        return (String[])this.tokenSigningAlgorithmsSupported.clone();
    }

    @Override
    public String[] getSupportedClaims() {
        return (String[])this.supportedClaims.clone();
    }

    public static AttestationOpenIdMetadata fromGenerated(Object generated) {
        AttestationOpenIdMetadataImpl metadataImpl;
        ClientLogger logger = new ClientLogger(AttestationOpenIdMetadataImpl.class);
        JacksonAdapter serializerAdapter = new JacksonAdapter();
        try {
            String generatedString = JSONObjectUtils.toJSONString((Map)((LinkedHashMap)generated));
            metadataImpl = (AttestationOpenIdMetadataImpl)serializerAdapter.deserialize(generatedString, AttestationOpenIdMetadataImpl.class, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        return metadataImpl;
    }
}

