/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.attestation.implementation.AttestationClientImpl;
import com.azure.security.attestation.implementation.models.CloudErrorException;
import com.azure.security.attestation.implementation.models.PolicyCertificatesModifyResponse;
import com.azure.security.attestation.implementation.models.PolicyCertificatesResponse;
import reactor.core.publisher.Mono;

public final class PolicyCertificatesImpl {
    private final PolicyCertificatesService service;
    private final AttestationClientImpl client;

    PolicyCertificatesImpl(AttestationClientImpl client) {
        this.service = (PolicyCertificatesService)RestProxy.create(PolicyCertificatesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyCertificatesResponse>> getWithResponseAsync(Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.get(this.client.getInstanceUrl(), this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyCertificatesModifyResponse>> addWithResponseAsync(String policyCertificateToAdd, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (policyCertificateToAdd == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyCertificateToAdd is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.add(this.client.getInstanceUrl(), this.client.getApiVersion(), policyCertificateToAdd, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyCertificatesModifyResponse>> removeWithResponseAsync(String policyCertificateToRemove, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (policyCertificateToRemove == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyCertificateToRemove is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.remove(this.client.getInstanceUrl(), this.client.getApiVersion(), policyCertificateToRemove, "application/json", context);
    }

    @Host(value="{instanceUrl}")
    @ServiceInterface(name="AttestationClientPol")
    public static interface PolicyCertificatesService {
        @Get(value="/certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<PolicyCertificatesResponse>> get(@HostParam(value="instanceUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/certificates:add")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<PolicyCertificatesModifyResponse>> add(@HostParam(value="instanceUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/certificates:remove")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<PolicyCertificatesModifyResponse>> remove(@HostParam(value="instanceUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

