/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.attestation.implementation.AttestationClientImpl;
import com.azure.security.attestation.implementation.models.AttestOpenEnclaveRequest;
import com.azure.security.attestation.implementation.models.AttestSgxEnclaveRequest;
import com.azure.security.attestation.implementation.models.AttestationResponse;
import com.azure.security.attestation.implementation.models.CloudErrorException;
import com.azure.security.attestation.implementation.models.TpmAttestationRequest;
import com.azure.security.attestation.implementation.models.TpmAttestationResponse;
import reactor.core.publisher.Mono;

public final class AttestationsImpl {
    private final AttestationsService service;
    private final AttestationClientImpl client;

    AttestationsImpl(AttestationClientImpl client) {
        this.service = (AttestationsService)RestProxy.create(AttestationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AttestationResponse>> attestOpenEnclaveWithResponseAsync(AttestOpenEnclaveRequest request, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return this.service.attestOpenEnclave(this.client.getInstanceUrl(), this.client.getApiVersion(), request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AttestationResponse>> attestSgxEnclaveWithResponseAsync(AttestSgxEnclaveRequest request, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return this.service.attestSgxEnclave(this.client.getInstanceUrl(), this.client.getApiVersion(), request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TpmAttestationResponse>> attestTpmWithResponseAsync(TpmAttestationRequest request, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return this.service.attestTpm(this.client.getInstanceUrl(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Host(value="{instanceUrl}")
    @ServiceInterface(name="AttestationClientAtt")
    public static interface AttestationsService {
        @Post(value="/attest/OpenEnclave")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<AttestationResponse>> attestOpenEnclave(@HostParam(value="instanceUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") AttestOpenEnclaveRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/attest/SgxEnclave")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<AttestationResponse>> attestSgxEnclave(@HostParam(value="instanceUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") AttestSgxEnclaveRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/attest/Tpm")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<TpmAttestationResponse>> attestTpm(@HostParam(value="instanceUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") TpmAttestationRequest var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

