/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation;

import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceExistsException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.models.ResponseError;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.security.attestation.implementation.models.CloudErrorBody;
import com.azure.security.attestation.implementation.models.CloudErrorException;
import com.azure.security.attestation.models.AttestationResponse;
import com.azure.security.attestation.models.AttestationToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;

class Utilities {
    Utilities() {
    }

    static <T, R> ResponseBase<Void, T> generateResponseFromModelType(Response<R> response, T value) {
        return new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, null);
    }

    static <T, R> AttestationResponse<T> generateAttestationResponseFromModelType(Response<R> response, AttestationToken token, T value) {
        return new AttestationResponse<T>(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, token);
    }

    static InputStream base64ToStream(String base64) {
        byte[] decoded = Base64.getDecoder().decode(base64);
        return new ByteArrayInputStream(decoded);
    }

    static Throwable mapException(Throwable exception) {
        ResponseError responseError;
        String jsonErrorBody;
        RuntimeException runtimeException;
        Throwable throwable;
        CloudErrorException cloudErrorException = null;
        ClientLogger logger = new ClientLogger(Utilities.class);
        if (exception instanceof CloudErrorException) {
            cloudErrorException = (CloudErrorException)((Object)exception);
        } else if (exception instanceof RuntimeException && (throwable = (runtimeException = (RuntimeException)exception).getCause()) instanceof CloudErrorException) {
            cloudErrorException = (CloudErrorException)((Object)throwable);
        }
        if (cloudErrorException == null) {
            return exception;
        }
        HttpResponse errorHttpResponse = cloudErrorException.getResponse();
        int statusCode = errorHttpResponse.getStatusCode();
        CloudErrorBody body = cloudErrorException.getValue().getError();
        JacksonAdapter serializer = new JacksonAdapter();
        try {
            jsonErrorBody = serializer.serialize((Object)body, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        try {
            responseError = (ResponseError)serializer.deserialize(jsonErrorBody, ResponseError.class, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        String errorDetail = cloudErrorException.getMessage();
        switch (statusCode) {
            case 401: {
                return new ClientAuthenticationException(errorDetail, cloudErrorException.getResponse(), (Object)responseError);
            }
            case 404: {
                return new ResourceNotFoundException(errorDetail, cloudErrorException.getResponse(), (Object)responseError);
            }
            case 409: {
                return new ResourceExistsException(errorDetail, cloudErrorException.getResponse(), (Object)responseError);
            }
            case 412: {
                return new ResourceModifiedException(errorDetail, cloudErrorException.getResponse(), (Object)responseError);
            }
        }
        return new HttpResponseException(errorDetail, cloudErrorException.getResponse(), (Object)responseError);
    }
}

