/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.security.attestation.AttestationAsyncClient;
import com.azure.security.attestation.AttestationClientBuilder;
import com.azure.security.attestation.models.AttestationOpenIdMetadata;
import com.azure.security.attestation.models.AttestationOptions;
import com.azure.security.attestation.models.AttestationResponse;
import com.azure.security.attestation.models.AttestationResult;
import com.azure.security.attestation.models.AttestationSignerCollection;

@ServiceClient(builder=AttestationClientBuilder.class)
public final class AttestationClient {
    private final AttestationAsyncClient asyncClient;

    AttestationClient(AttestationAsyncClient serviceClient) {
        this.asyncClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationOpenIdMetadata getOpenIdMetadata() {
        return (AttestationOpenIdMetadata)this.asyncClient.getOpenIdMetadataWithResponse().map(Response::getValue).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AttestationOpenIdMetadata> getOpenIdMetadataWithResponse(Context context) {
        return (Response)this.asyncClient.getOpenIdMetadataWithResponse(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationSignerCollection listAttestationSigners() {
        return (AttestationSignerCollection)this.asyncClient.listAttestationSignersWithResponse().map(Response::getValue).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AttestationSignerCollection> listAttestationSignersWithResponse(Context context) {
        return (Response)this.asyncClient.listAttestationSignersWithResponse(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResult attestOpenEnclave(BinaryData report) {
        return (AttestationResult)this.asyncClient.attestOpenEnclave(new AttestationOptions(report)).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResult attestOpenEnclave(AttestationOptions options) {
        return (AttestationResult)this.asyncClient.attestOpenEnclave(options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResponse<AttestationResult> attestOpenEnclaveWithResponse(AttestationOptions options, Context context) {
        return (AttestationResponse)((Object)this.asyncClient.attestOpenEnclaveWithResponse(options, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResult attestSgxEnclave(BinaryData quote) {
        return (AttestationResult)this.asyncClient.attestSgxEnclave(quote).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResult attestSgxEnclave(AttestationOptions options) {
        return (AttestationResult)this.asyncClient.attestSgxEnclave(options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResponse<AttestationResult> attestSgxEnclaveWithResponse(AttestationOptions request, Context context) {
        return (AttestationResponse)((Object)this.asyncClient.attestSgxEnclaveWithResponse(request, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String attestTpm(String request) {
        return (String)this.asyncClient.attestTpm(request).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> attestTpmWithResponse(String request, Context context) {
        return (Response)this.asyncClient.attestTpmWithResponse(request, context).block();
    }
}

