/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.security.attestation.AttestationAdministrationAsyncClient;
import com.azure.security.attestation.AttestationAdministrationClientBuilder;
import com.azure.security.attestation.models.AttestationPolicySetOptions;
import com.azure.security.attestation.models.AttestationResponse;
import com.azure.security.attestation.models.AttestationSignerCollection;
import com.azure.security.attestation.models.AttestationSigningKey;
import com.azure.security.attestation.models.AttestationTokenValidationOptions;
import com.azure.security.attestation.models.AttestationType;
import com.azure.security.attestation.models.PolicyCertificatesModificationResult;
import com.azure.security.attestation.models.PolicyManagementCertificateOptions;
import com.azure.security.attestation.models.PolicyResult;

@ServiceClient(builder=AttestationAdministrationClientBuilder.class)
public final class AttestationAdministrationClient {
    private final AttestationAdministrationAsyncClient asyncClient;

    AttestationAdministrationClient(AttestationAdministrationAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getAttestationPolicy(AttestationType attestationType) {
        return (String)this.asyncClient.getAttestationPolicy(attestationType).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getAttestationPolicy(AttestationType attestationType, AttestationTokenValidationOptions options) {
        return (String)this.asyncClient.getAttestationPolicy(attestationType, options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResponse<String> getAttestationPolicyWithResponse(AttestationType attestationType, AttestationTokenValidationOptions validationOptions, Context context) {
        return (AttestationResponse)((Object)this.asyncClient.getAttestationPolicyWithResponse(attestationType, validationOptions, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyResult setAttestationPolicy(AttestationType attestationType, String policyToSet) {
        return (PolicyResult)this.asyncClient.setAttestationPolicy(attestationType, policyToSet).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyResult setAttestationPolicy(AttestationType attestationType, AttestationPolicySetOptions options) {
        return (PolicyResult)this.asyncClient.setAttestationPolicy(attestationType, options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResponse<PolicyResult> setAttestationPolicyWithResponse(AttestationType attestationType, AttestationPolicySetOptions options, Context context) {
        return (AttestationResponse)((Object)this.asyncClient.setAttestationPolicyWithResponse(attestationType, options, context).block());
    }

    public BinaryData calculatePolicyTokenHash(String policy, AttestationSigningKey signer) {
        return this.asyncClient.calculatePolicyTokenHash(policy, signer);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyResult resetAttestationPolicy(AttestationType attestationType) {
        return (PolicyResult)this.asyncClient.resetAttestationPolicy(attestationType).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyResult resetAttestationPolicy(AttestationType attestationType, AttestationPolicySetOptions options) {
        return (PolicyResult)this.asyncClient.resetAttestationPolicy(attestationType, options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResponse<PolicyResult> resetAttestationPolicyWithResponse(AttestationType attestationType, AttestationPolicySetOptions options, Context context) {
        return (AttestationResponse)((Object)this.asyncClient.resetAttestationPolicyWithResponse(attestationType, options, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationSignerCollection listPolicyManagementCertificates() {
        return (AttestationSignerCollection)this.asyncClient.listPolicyManagementCertificates().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResponse<AttestationSignerCollection> listPolicyManagementCertificatesWithResponse(AttestationTokenValidationOptions tokenValidationOptions, Context context) {
        return (AttestationResponse)((Object)this.asyncClient.listPolicyManagementCertificatesWithResponse(tokenValidationOptions, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyCertificatesModificationResult addPolicyManagementCertificate(PolicyManagementCertificateOptions options) {
        return (PolicyCertificatesModificationResult)this.asyncClient.addPolicyManagementCertificate(options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResponse<PolicyCertificatesModificationResult> addPolicyManagementCertificateWithResponse(PolicyManagementCertificateOptions options, Context context) {
        return (AttestationResponse)((Object)this.asyncClient.addPolicyManagementCertificateWithResponse(options, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyCertificatesModificationResult deletePolicyManagementCertificate(PolicyManagementCertificateOptions options) {
        return (PolicyCertificatesModificationResult)this.asyncClient.deletePolicyManagementCertificate(options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AttestationResponse<PolicyCertificatesModificationResult> deletePolicyManagementCertificateWithResponse(PolicyManagementCertificateOptions options, Context context) {
        return (AttestationResponse)((Object)this.asyncClient.deletePolicyManagementCertificateWithResponse(options, context).block());
    }
}

