/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.attestation;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.security.attestation.AttestationClientBuilder;
import com.azure.security.attestation.Utilities;
import com.azure.security.attestation.implementation.AttestationClientImpl;
import com.azure.security.attestation.implementation.PoliciesImpl;
import com.azure.security.attestation.implementation.PolicyCertificatesImpl;
import com.azure.security.attestation.implementation.SigningCertificatesImpl;
import com.azure.security.attestation.implementation.models.AttestationCertificateManagementBody;
import com.azure.security.attestation.implementation.models.AttestationSignerCollectionImpl;
import com.azure.security.attestation.implementation.models.AttestationSignerImpl;
import com.azure.security.attestation.implementation.models.AttestationTokenImpl;
import com.azure.security.attestation.implementation.models.JsonWebKey;
import com.azure.security.attestation.implementation.models.JsonWebKeySet;
import com.azure.security.attestation.implementation.models.PolicyCertificatesModificationResultImpl;
import com.azure.security.attestation.implementation.models.PolicyCertificatesModifyResponse;
import com.azure.security.attestation.implementation.models.PolicyCertificatesResponse;
import com.azure.security.attestation.implementation.models.PolicyCertificatesResult;
import com.azure.security.attestation.implementation.models.PolicyResponse;
import com.azure.security.attestation.implementation.models.PolicyResultImpl;
import com.azure.security.attestation.implementation.models.StoredAttestationPolicy;
import com.azure.security.attestation.models.AttestationPolicySetOptions;
import com.azure.security.attestation.models.AttestationResponse;
import com.azure.security.attestation.models.AttestationSigner;
import com.azure.security.attestation.models.AttestationSignerCollection;
import com.azure.security.attestation.models.AttestationSigningKey;
import com.azure.security.attestation.models.AttestationToken;
import com.azure.security.attestation.models.AttestationTokenValidationOptions;
import com.azure.security.attestation.models.AttestationType;
import com.azure.security.attestation.models.PolicyCertificatesModificationResult;
import com.azure.security.attestation.models.PolicyManagementCertificateOptions;
import com.azure.security.attestation.models.PolicyResult;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AttestationClientBuilder.class, isAsync=true)
public final class AttestationAdministrationAsyncClient {
    private final SigningCertificatesImpl signingCertificatesImpl;
    private final PoliciesImpl policyImpl;
    private final PolicyCertificatesImpl certificatesImpl;
    private final ClientLogger logger;
    private final AttestationTokenValidationOptions tokenValidationOptions;
    private final AtomicReference<List<AttestationSigner>> cachedSigners;
    private static final SerializerAdapter SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();

    AttestationAdministrationAsyncClient(AttestationClientImpl clientImpl, AttestationTokenValidationOptions tokenValidationOptions) {
        this.signingCertificatesImpl = clientImpl.getSigningCertificates();
        this.policyImpl = clientImpl.getPolicies();
        this.certificatesImpl = clientImpl.getPolicyCertificates();
        this.tokenValidationOptions = tokenValidationOptions;
        this.logger = new ClientLogger(AttestationAdministrationAsyncClient.class);
        this.cachedSigners = new AtomicReference<Object>(null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResponse<String>> getAttestationPolicyWithResponse(AttestationType attestationType, AttestationTokenValidationOptions validationOptions) {
        return FluxUtil.withContext(context -> this.getAttestationPolicyWithResponse(attestationType, validationOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getAttestationPolicy(AttestationType attestationType) {
        return this.getAttestationPolicyWithResponse(attestationType, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getAttestationPolicy(AttestationType attestationType, AttestationTokenValidationOptions options) {
        return this.getAttestationPolicyWithResponse(attestationType, options).flatMap(FluxUtil::toMono);
    }

    Mono<AttestationResponse<String>> getAttestationPolicyWithResponse(AttestationType attestationType, AttestationTokenValidationOptions validationOptions, Context context) {
        AttestationTokenValidationOptions validationOptionsToUse = validationOptions != null ? validationOptions : this.tokenValidationOptions;
        return this.policyImpl.getWithResponseAsync(attestationType, context).onErrorMap(Utilities::mapException).flatMap(response -> {
            ResponseBase<Void, AttestationTokenImpl> token = Utilities.generateResponseFromModelType(response, new AttestationTokenImpl(((PolicyResponse)response.getValue()).getToken()));
            return this.getCachedAttestationSigners(context).map(signers -> {
                ((AttestationTokenImpl)token.getValue()).validate((List<AttestationSigner>)signers, validationOptionsToUse);
                String policyJwt = ((AttestationTokenImpl)token.getValue()).getBody(com.azure.security.attestation.implementation.models.PolicyResult.class).getPolicy();
                AttestationTokenImpl policyToken = new AttestationTokenImpl(policyJwt);
                StoredAttestationPolicy storedPolicy = policyToken.getBody(StoredAttestationPolicy.class);
                String policy = storedPolicy != null ? new String(storedPolicy.getAttestationPolicy(), StandardCharsets.UTF_8) : null;
                return Utilities.generateAttestationResponseFromModelType(token, policyToken, policy);
            });
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyResult> setAttestationPolicy(AttestationType attestationType, String newAttestationPolicy) {
        AttestationPolicySetOptions options = new AttestationPolicySetOptions().setAttestationPolicy(newAttestationPolicy);
        return this.setAttestationPolicyWithResponse(attestationType, options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyResult> setAttestationPolicy(AttestationType attestationType, AttestationPolicySetOptions options) {
        return this.setAttestationPolicyWithResponse(attestationType, options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResponse<PolicyResult>> setAttestationPolicyWithResponse(AttestationType attestationType, AttestationPolicySetOptions options) {
        return FluxUtil.withContext(context -> this.setAttestationPolicyWithResponse(attestationType, options, (Context)context));
    }

    Mono<AttestationResponse<PolicyResult>> setAttestationPolicyWithResponse(AttestationType attestationType, AttestationPolicySetOptions options, Context context) {
        AttestationTokenValidationOptions validationOptions = options.getValidationOptions();
        if (validationOptions == null) {
            validationOptions = this.tokenValidationOptions;
        }
        AttestationTokenValidationOptions finalOptions = validationOptions;
        AttestationToken setToken = this.generatePolicySetToken(options.getAttestationPolicy(), options.getAttestationSigner());
        return this.policyImpl.setWithResponseAsync(attestationType, setToken.serialize(), context).onErrorMap(Utilities::mapException).flatMap(response -> {
            ResponseBase<Void, AttestationTokenImpl> token = Utilities.generateResponseFromModelType(response, new AttestationTokenImpl(((PolicyResponse)response.getValue()).getToken()));
            return this.getCachedAttestationSigners(context).map(signers -> {
                ((AttestationTokenImpl)token.getValue()).validate((List<AttestationSigner>)signers, finalOptions);
                PolicyResult policyResult = PolicyResultImpl.fromGenerated(((AttestationTokenImpl)token.getValue()).getBody(com.azure.security.attestation.implementation.models.PolicyResult.class));
                return Utilities.generateAttestationResponseFromModelType(response, (AttestationToken)token.getValue(), policyResult);
            });
        });
    }

    public BinaryData calculatePolicyTokenHash(String policy, AttestationSigningKey signer) {
        AttestationToken policyToken = this.generatePolicySetToken(policy, signer);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.reset();
            md.update(policyToken.serialize().getBytes(StandardCharsets.UTF_8));
            return BinaryData.fromBytes((byte[])md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
    }

    private AttestationToken generatePolicySetToken(String policy, AttestationSigningKey signer) {
        String serializedPolicy = null;
        if (policy != null) {
            StoredAttestationPolicy policyToSet = new StoredAttestationPolicy();
            policyToSet.setAttestationPolicy(policy.getBytes(StandardCharsets.UTF_8));
            try {
                serializedPolicy = SERIALIZER_ADAPTER.serialize((Object)policyToSet, SerializerEncoding.JSON);
            }
            catch (IOException e) {
                throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
            }
        }
        AttestationToken setToken = signer == null ? (policy != null ? AttestationTokenImpl.createUnsecuredToken(serializedPolicy) : AttestationTokenImpl.createUnsecuredToken()) : (policy != null ? AttestationTokenImpl.createSecuredToken(serializedPolicy, signer) : AttestationTokenImpl.createSecuredToken(signer));
        return setToken;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyResult> resetAttestationPolicy(AttestationType attestationType) {
        return this.resetAttestationPolicyWithResponse(attestationType, new AttestationPolicySetOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyResult> resetAttestationPolicy(AttestationType attestationType, AttestationPolicySetOptions options) {
        return this.resetAttestationPolicyWithResponse(attestationType, options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResponse<PolicyResult>> resetAttestationPolicyWithResponse(AttestationType attestationType, AttestationPolicySetOptions options) {
        return FluxUtil.withContext(context -> this.resetAttestationPolicyWithResponse(attestationType, options, (Context)context));
    }

    Mono<AttestationResponse<PolicyResult>> resetAttestationPolicyWithResponse(AttestationType attestationType, AttestationPolicySetOptions options, Context context) {
        AttestationTokenValidationOptions validationOptions;
        if (options.getAttestationPolicy() != null) {
            this.logger.logThrowableAsError((Throwable)new InvalidParameterException("Attestation policy should not be set in resetAttestationPolicy"));
        }
        if ((validationOptions = options.getValidationOptions()) == null) {
            validationOptions = this.tokenValidationOptions;
        }
        AttestationTokenValidationOptions finalOptions = validationOptions;
        AttestationToken setToken = options.getAttestationSigner() == null ? AttestationTokenImpl.createUnsecuredToken() : AttestationTokenImpl.createSecuredToken(options.getAttestationSigner());
        return this.policyImpl.resetWithResponseAsync(attestationType, setToken.serialize(), context).onErrorMap(Utilities::mapException).flatMap(response -> {
            ResponseBase<Void, AttestationTokenImpl> token = Utilities.generateResponseFromModelType(response, new AttestationTokenImpl(((PolicyResponse)response.getValue()).getToken()));
            return this.getCachedAttestationSigners(context).map(signers -> {
                ((AttestationTokenImpl)token.getValue()).validate((List<AttestationSigner>)signers, finalOptions);
                PolicyResult policyResult = PolicyResultImpl.fromGenerated(((AttestationTokenImpl)token.getValue()).getBody(com.azure.security.attestation.implementation.models.PolicyResult.class));
                return Utilities.generateAttestationResponseFromModelType(response, (AttestationToken)token.getValue(), policyResult);
            });
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationSignerCollection> listPolicyManagementCertificates() {
        return this.listPolicyManagementCertificatesWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResponse<AttestationSignerCollection>> listPolicyManagementCertificatesWithResponse(AttestationTokenValidationOptions options) {
        return FluxUtil.withContext(context -> this.listPolicyManagementCertificatesWithResponse(options, (Context)context));
    }

    Mono<AttestationResponse<AttestationSignerCollection>> listPolicyManagementCertificatesWithResponse(AttestationTokenValidationOptions validationOptions, Context context) {
        AttestationTokenValidationOptions optionsToUse = validationOptions != null ? validationOptions : this.tokenValidationOptions;
        return this.certificatesImpl.getWithResponseAsync(context).onErrorMap(Utilities::mapException).flatMap(response -> {
            ResponseBase<Void, AttestationTokenImpl> responseWithToken = Utilities.generateResponseFromModelType(response, new AttestationTokenImpl(((PolicyCertificatesResponse)response.getValue()).getToken()));
            return this.getCachedAttestationSigners(context).map(signers -> {
                ((AttestationTokenImpl)responseWithToken.getValue()).validate((List<AttestationSigner>)signers, optionsToUse);
                JsonWebKeySet policyJwks = ((AttestationTokenImpl)responseWithToken.getValue()).getBody(PolicyCertificatesResult.class).getPolicyCertificates();
                List<AttestationSigner> policySigners = AttestationSignerImpl.attestationSignersFromJwks(policyJwks);
                return Utilities.generateAttestationResponseFromModelType(responseWithToken, (AttestationToken)responseWithToken.getValue(), new AttestationSignerCollectionImpl(policySigners));
            });
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyCertificatesModificationResult> addPolicyManagementCertificate(PolicyManagementCertificateOptions options) {
        return this.addPolicyManagementCertificateWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResponse<PolicyCertificatesModificationResult>> addPolicyManagementCertificateWithResponse(PolicyManagementCertificateOptions options) {
        return FluxUtil.withContext(context -> this.addPolicyManagementCertificateWithResponse(options, (Context)context));
    }

    Mono<AttestationResponse<PolicyCertificatesModificationResult>> addPolicyManagementCertificateWithResponse(PolicyManagementCertificateOptions options, Context context) {
        AttestationToken addToken;
        String base64Certificate;
        Objects.requireNonNull(options.getCertificate());
        Objects.requireNonNull(options.getAttestationSigner());
        AttestationTokenValidationOptions finalOptions = this.tokenValidationOptions;
        try {
            base64Certificate = Base64.getEncoder().encodeToString(options.getCertificate().getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        JsonWebKey jwk = new JsonWebKey(options.getCertificate().getType()).setX5C(new ArrayList<String>());
        jwk.getX5C().add(base64Certificate);
        AttestationCertificateManagementBody certificateBody = new AttestationCertificateManagementBody().setPolicyCertificate(jwk);
        try {
            addToken = AttestationTokenImpl.createSecuredToken(SERIALIZER_ADAPTER.serialize((Object)certificateBody, SerializerEncoding.JSON), options.getAttestationSigner());
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        return this.certificatesImpl.addWithResponseAsync(addToken.serialize(), context).onErrorMap(Utilities::mapException).flatMap(response -> {
            ResponseBase<Void, AttestationTokenImpl> token = Utilities.generateResponseFromModelType(response, new AttestationTokenImpl(((PolicyCertificatesModifyResponse)response.getValue()).getToken()));
            return this.getCachedAttestationSigners(context).map(signers -> {
                ((AttestationTokenImpl)token.getValue()).validate((List<AttestationSigner>)signers, finalOptions);
                PolicyCertificatesModificationResult addResult = PolicyCertificatesModificationResultImpl.fromGenerated(((AttestationTokenImpl)token.getValue()).getBody(com.azure.security.attestation.implementation.models.PolicyCertificatesModificationResult.class));
                return Utilities.generateAttestationResponseFromModelType(response, (AttestationToken)token.getValue(), addResult);
            });
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyCertificatesModificationResult> deletePolicyManagementCertificate(PolicyManagementCertificateOptions options) {
        return this.deletePolicyManagementCertificateWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AttestationResponse<PolicyCertificatesModificationResult>> deletePolicyManagementCertificateWithResponse(PolicyManagementCertificateOptions options) {
        return FluxUtil.withContext(context -> this.deletePolicyManagementCertificateWithResponse(options, (Context)context));
    }

    Mono<AttestationResponse<PolicyCertificatesModificationResult>> deletePolicyManagementCertificateWithResponse(PolicyManagementCertificateOptions options, Context context) {
        AttestationToken addToken;
        String base64Certificate;
        Objects.requireNonNull(options.getCertificate());
        Objects.requireNonNull(options.getAttestationSigner());
        AttestationTokenValidationOptions finalOptions = this.tokenValidationOptions;
        try {
            base64Certificate = Base64.getEncoder().encodeToString(options.getCertificate().getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        JsonWebKey jwk = new JsonWebKey(options.getCertificate().getType()).setX5C(new ArrayList<String>());
        jwk.getX5C().add(base64Certificate);
        AttestationCertificateManagementBody certificateBody = new AttestationCertificateManagementBody().setPolicyCertificate(jwk);
        try {
            addToken = AttestationTokenImpl.createSecuredToken(SERIALIZER_ADAPTER.serialize((Object)certificateBody, SerializerEncoding.JSON), options.getAttestationSigner());
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e.getMessage()));
        }
        return this.certificatesImpl.removeWithResponseAsync(addToken.serialize(), context).onErrorMap(Utilities::mapException).flatMap(response -> {
            ResponseBase<Void, AttestationTokenImpl> token = Utilities.generateResponseFromModelType(response, new AttestationTokenImpl(((PolicyCertificatesModifyResponse)response.getValue()).getToken()));
            return this.getCachedAttestationSigners(context).map(signers -> {
                ((AttestationTokenImpl)token.getValue()).validate((List<AttestationSigner>)signers, finalOptions);
                PolicyCertificatesModificationResult addResult = PolicyCertificatesModificationResultImpl.fromGenerated(((AttestationTokenImpl)token.getValue()).getBody(com.azure.security.attestation.implementation.models.PolicyCertificatesModificationResult.class));
                return Utilities.generateAttestationResponseFromModelType(response, (AttestationToken)token.getValue(), addResult);
            });
        });
    }

    Mono<List<AttestationSigner>> getCachedAttestationSigners(Context context) {
        if (this.cachedSigners.get() != null) {
            return Mono.just(this.cachedSigners.get());
        }
        return this.signingCertificatesImpl.getWithResponseAsync(context).map(response -> AttestationSignerImpl.attestationSignersFromJwks((JsonWebKeySet)response.getValue())).map(signers -> {
            this.cachedSigners.compareAndSet((List<AttestationSigner>)null, (List<AttestationSigner>)signers);
            return this.cachedSigners.get();
        });
    }
}

