/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.search.documents.SearchDocument;
import com.azure.search.documents.implementation.converters.SearchResultHelper;
import com.azure.search.documents.models.DocumentDebugInfo;
import com.azure.search.documents.models.QueryCaptionResult;
import com.azure.search.documents.models.SemanticSearchResult;
import java.util.List;
import java.util.Map;

public final class SearchResult {
    private final double score;
    private SemanticSearchResult semanticSearch;
    private Map<String, List<String>> highlights;
    private DocumentDebugInfo documentDebugInfo;
    private Map<String, Object> additionalProperties;
    private JsonSerializer jsonSerializer;

    public SearchResult(double score) {
        this.score = score;
    }

    public double getScore() {
        return this.score;
    }

    public Map<String, List<String>> getHighlights() {
        return this.highlights;
    }

    public SemanticSearchResult getSemanticSearch() {
        return this.semanticSearch;
    }

    public DocumentDebugInfo getDocumentDebugInfo() {
        return this.documentDebugInfo;
    }

    public <T> T getDocument(Class<T> modelClass) {
        return (T)this.jsonSerializer.deserializeFromBytes(this.jsonSerializer.serializeToBytes(this.additionalProperties), TypeReference.createInstance(modelClass));
    }

    private void setAdditionalProperties(SearchDocument additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    private void setHighlights(Map<String, List<String>> highlights) {
        this.highlights = highlights;
    }

    private void setJsonSerializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    private void setDocumentDebugInfo(DocumentDebugInfo documentDebugInfo) {
        this.documentDebugInfo = documentDebugInfo;
    }

    private void setSemanticSearchResult(Double rerankerScore, List<QueryCaptionResult> captions) {
        this.semanticSearch = new SemanticSearchResult(rerankerScore, captions);
    }

    static {
        SearchResultHelper.setAccessor(new SearchResultHelper.SearchResultAccessor(){

            @Override
            public void setAdditionalProperties(SearchResult searchResult, SearchDocument additionalProperties) {
                searchResult.setAdditionalProperties(additionalProperties);
            }

            @Override
            public void setHighlights(SearchResult searchResult, Map<String, List<String>> highlights) {
                searchResult.setHighlights(highlights);
            }

            @Override
            public void setJsonSerializer(SearchResult searchResult, JsonSerializer jsonSerializer) {
                searchResult.setJsonSerializer(jsonSerializer);
            }

            @Override
            public void setSemanticSearchResults(SearchResult searchResult, Double rerankerScore, List<QueryCaptionResult> captions) {
                searchResult.setSemanticSearchResult(rerankerScore, captions);
            }

            @Override
            public void setDocumentDebugInfo(SearchResult searchResult, DocumentDebugInfo documentDebugInfo) {
                searchResult.setDocumentDebugInfo(documentDebugInfo);
            }
        });
    }
}

