/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SnowballTokenFilterLanguage;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;

public final class SnowballTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.SnowballTokenFilter";
    private final SnowballTokenFilterLanguage language;

    public SnowballTokenFilter(String name, SnowballTokenFilterLanguage language) {
        super(name);
        this.language = language;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public SnowballTokenFilterLanguage getLanguage() {
        return this.language;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("language", this.language == null ? null : this.language.toString());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static SnowballTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (SnowballTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean languageFound = false;
            SnowballTokenFilterLanguage language = null;
            String odataType = "#Microsoft.Azure.Search.SnowballTokenFilter";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("language".equals(fieldName)) {
                    language = SnowballTokenFilterLanguage.fromString(reader.getString());
                    languageFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && languageFound) {
                SnowballTokenFilter deserializedSnowballTokenFilter = new SnowballTokenFilter(name, language);
                deserializedSnowballTokenFilter.odataType = odataType;
                return deserializedSnowballTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!languageFound) {
                missingProperties.add("language");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

