/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SemanticPrioritizedFields;
import java.io.IOException;
import java.util.ArrayList;

public final class SemanticConfiguration
implements JsonSerializable<SemanticConfiguration> {
    private final String name;
    private final SemanticPrioritizedFields prioritizedFields;
    private Boolean flightingOptIn;

    public SemanticConfiguration(String name, SemanticPrioritizedFields prioritizedFields) {
        this.name = name;
        this.prioritizedFields = prioritizedFields;
    }

    public String getName() {
        return this.name;
    }

    public SemanticPrioritizedFields getPrioritizedFields() {
        return this.prioritizedFields;
    }

    public Boolean isFlightingOptIn() {
        return this.flightingOptIn;
    }

    public SemanticConfiguration setFlightingOptIn(Boolean flightingOptIn) {
        this.flightingOptIn = flightingOptIn;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("prioritizedFields", (JsonSerializable)this.prioritizedFields);
        jsonWriter.writeBooleanField("flightingOptIn", this.flightingOptIn);
        return jsonWriter.writeEndObject();
    }

    public static SemanticConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (SemanticConfiguration)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean prioritizedFieldsFound = false;
            SemanticPrioritizedFields prioritizedFields = null;
            Boolean flightingOptIn = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("prioritizedFields".equals(fieldName)) {
                    prioritizedFields = SemanticPrioritizedFields.fromJson(reader);
                    prioritizedFieldsFound = true;
                    continue;
                }
                if ("flightingOptIn".equals(fieldName)) {
                    flightingOptIn = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && prioritizedFieldsFound) {
                SemanticConfiguration deserializedSemanticConfiguration = new SemanticConfiguration(name, prioritizedFields);
                deserializedSemanticConfiguration.flightingOptIn = flightingOptIn;
                return deserializedSemanticConfiguration;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!prioritizedFieldsFound) {
                missingProperties.add("prioritizedFields");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

