/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OcrLineEnding;
import com.azure.search.documents.indexes.models.OcrSkillLanguage;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class OcrSkill
extends SearchIndexerSkill {
    private String odataType = "#Microsoft.Skills.Vision.OcrSkill";
    private OcrSkillLanguage defaultLanguageCode;
    private Boolean shouldDetectOrientation;
    private OcrLineEnding lineEnding;

    public OcrSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public OcrSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public OcrSkill setDefaultLanguageCode(OcrSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public Boolean isShouldDetectOrientation() {
        return this.shouldDetectOrientation;
    }

    public OcrSkill setShouldDetectOrientation(Boolean shouldDetectOrientation) {
        this.shouldDetectOrientation = shouldDetectOrientation;
        return this;
    }

    public OcrLineEnding getLineEnding() {
        return this.lineEnding;
    }

    public OcrSkill setLineEnding(OcrLineEnding lineEnding) {
        this.lineEnding = lineEnding;
        return this;
    }

    @Override
    public OcrSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public OcrSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public OcrSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("defaultLanguageCode", this.defaultLanguageCode == null ? null : this.defaultLanguageCode.toString());
        jsonWriter.writeBooleanField("detectOrientation", this.shouldDetectOrientation);
        jsonWriter.writeStringField("lineEnding", this.lineEnding == null ? null : this.lineEnding.toString());
        return jsonWriter.writeEndObject();
    }

    public static OcrSkill fromJson(JsonReader jsonReader) throws IOException {
        return (OcrSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String odataType = "#Microsoft.Skills.Vision.OcrSkill";
            OcrSkillLanguage defaultLanguageCode = null;
            Boolean shouldDetectOrientation = null;
            OcrLineEnding lineEnding = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("defaultLanguageCode".equals(fieldName)) {
                    defaultLanguageCode = OcrSkillLanguage.fromString(reader.getString());
                    continue;
                }
                if ("detectOrientation".equals(fieldName)) {
                    shouldDetectOrientation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lineEnding".equals(fieldName)) {
                    lineEnding = OcrLineEnding.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                OcrSkill deserializedOcrSkill = new OcrSkill(inputs, outputs);
                deserializedOcrSkill.setName(name);
                deserializedOcrSkill.setDescription(description);
                deserializedOcrSkill.setContext(context);
                deserializedOcrSkill.odataType = odataType;
                deserializedOcrSkill.defaultLanguageCode = defaultLanguageCode;
                deserializedOcrSkill.shouldDetectOrientation = shouldDetectOrientation;
                deserializedOcrSkill.lineEnding = lineEnding;
                return deserializedOcrSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    @Deprecated
    public Boolean setShouldDetectOrientation() {
        return this.shouldDetectOrientation;
    }
}

