/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class LimitTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.LimitTokenFilter";
    private Integer maxTokenCount;
    private Boolean allTokensConsumed;

    public LimitTokenFilter(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Integer getMaxTokenCount() {
        return this.maxTokenCount;
    }

    public LimitTokenFilter setMaxTokenCount(Integer maxTokenCount) {
        this.maxTokenCount = maxTokenCount;
        return this;
    }

    public Boolean areAllTokensConsumed() {
        return this.allTokensConsumed;
    }

    public LimitTokenFilter setAllTokensConsumed(Boolean allTokensConsumed) {
        this.allTokensConsumed = allTokensConsumed;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("maxTokenCount", (Number)this.maxTokenCount);
        jsonWriter.writeBooleanField("consumeAllTokens", this.allTokensConsumed);
        return jsonWriter.writeEndObject();
    }

    public static LimitTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (LimitTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.LimitTokenFilter";
            Integer maxTokenCount = null;
            Boolean allTokensConsumed = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("maxTokenCount".equals(fieldName)) {
                    maxTokenCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("consumeAllTokens".equals(fieldName)) {
                    allTokensConsumed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                LimitTokenFilter deserializedLimitTokenFilter = new LimitTokenFilter(name);
                deserializedLimitTokenFilter.odataType = odataType;
                deserializedLimitTokenFilter.maxTokenCount = maxTokenCount;
                deserializedLimitTokenFilter.allTokensConsumed = allTokensConsumed;
                return deserializedLimitTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

