/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CustomAnalyzer;
import com.azure.search.documents.indexes.models.LuceneStandardAnalyzer;
import com.azure.search.documents.indexes.models.PatternAnalyzer;
import com.azure.search.documents.indexes.models.StopAnalyzer;
import java.io.IOException;

public class LexicalAnalyzer
implements JsonSerializable<LexicalAnalyzer> {
    private String odataType = "LexicalAnalyzer";
    private final String name;

    public LexicalAnalyzer(String name) {
        this.name = name;
    }

    public String getOdataType() {
        return this.odataType;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static LexicalAnalyzer fromJson(JsonReader jsonReader) throws IOException {
        return (LexicalAnalyzer)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                LexicalAnalyzer lexicalAnalyzer;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Azure.Search.CustomAnalyzer".equals(discriminatorValue)) {
                    lexicalAnalyzer = CustomAnalyzer.fromJson(readerToUse.reset());
                    return lexicalAnalyzer;
                }
                if ("#Microsoft.Azure.Search.PatternAnalyzer".equals(discriminatorValue)) {
                    lexicalAnalyzer = PatternAnalyzer.fromJson(readerToUse.reset());
                    return lexicalAnalyzer;
                }
                if ("#Microsoft.Azure.Search.StandardAnalyzer".equals(discriminatorValue)) {
                    lexicalAnalyzer = LuceneStandardAnalyzer.fromJson(readerToUse.reset());
                    return lexicalAnalyzer;
                }
                if ("#Microsoft.Azure.Search.StopAnalyzer".equals(discriminatorValue)) {
                    lexicalAnalyzer = StopAnalyzer.fromJson(readerToUse.reset());
                    return lexicalAnalyzer;
                }
                lexicalAnalyzer = LexicalAnalyzer.fromJsonKnownDiscriminator(readerToUse.reset());
                return lexicalAnalyzer;
            }
        });
    }

    static LexicalAnalyzer fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (LexicalAnalyzer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                LexicalAnalyzer deserializedLexicalAnalyzer = new LexicalAnalyzer(name);
                deserializedLexicalAnalyzer.odataType = odataType;
                return deserializedLexicalAnalyzer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

