/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class IndexStatisticsSummary
implements JsonSerializable<IndexStatisticsSummary> {
    private final String name;
    private final long documentCount;
    private final long storageSize;
    private final long vectorIndexSize;

    public IndexStatisticsSummary(String name, long documentCount, long storageSize, long vectorIndexSize) {
        this.name = name;
        this.documentCount = documentCount;
        this.storageSize = storageSize;
        this.vectorIndexSize = vectorIndexSize;
    }

    public String getName() {
        return this.name;
    }

    public long getDocumentCount() {
        return this.documentCount;
    }

    public long getStorageSize() {
        return this.storageSize;
    }

    public long getVectorIndexSize() {
        return this.vectorIndexSize;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static IndexStatisticsSummary fromJson(JsonReader jsonReader) throws IOException {
        return (IndexStatisticsSummary)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean documentCountFound = false;
            long documentCount = 0L;
            boolean storageSizeFound = false;
            long storageSize = 0L;
            boolean vectorIndexSizeFound = false;
            long vectorIndexSize = 0L;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("documentCount".equals(fieldName)) {
                    documentCount = reader.getLong();
                    documentCountFound = true;
                    continue;
                }
                if ("storageSize".equals(fieldName)) {
                    storageSize = reader.getLong();
                    storageSizeFound = true;
                    continue;
                }
                if ("vectorIndexSize".equals(fieldName)) {
                    vectorIndexSize = reader.getLong();
                    vectorIndexSizeFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && documentCountFound && storageSizeFound && vectorIndexSizeFound) {
                return new IndexStatisticsSummary(name, documentCount, storageSize, vectorIndexSize);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!documentCountFound) {
                missingProperties.add("documentCount");
            }
            if (!storageSizeFound) {
                missingProperties.add("storageSize");
            }
            if (!vectorIndexSizeFound) {
                missingProperties.add("vectorIndexSize");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

