/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ElisionTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.ElisionTokenFilter";
    private List<String> articles;

    public ElisionTokenFilter(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public List<String> getArticles() {
        return this.articles;
    }

    public ElisionTokenFilter setArticles(List<String> articles) {
        this.articles = articles;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeArrayField("articles", this.articles, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ElisionTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ElisionTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.ElisionTokenFilter";
            List articles = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("articles".equals(fieldName)) {
                    articles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                ElisionTokenFilter deserializedElisionTokenFilter = new ElisionTokenFilter(name);
                deserializedElisionTokenFilter.odataType = odataType;
                deserializedElisionTokenFilter.articles = articles;
                return deserializedElisionTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    public ElisionTokenFilter setArticles(String ... articles) {
        this.articles = articles == null ? null : Arrays.asList(articles);
        return this;
    }
}

