/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.DocumentIntelligenceLayoutSkillMarkdownHeaderDepth;
import com.azure.search.documents.indexes.models.DocumentIntelligenceLayoutSkillOutputMode;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentIntelligenceLayoutSkill
extends SearchIndexerSkill {
    private String odataType = "#Microsoft.Skills.Util.DocumentIntelligenceLayoutSkill";
    private DocumentIntelligenceLayoutSkillOutputMode outputMode;
    private DocumentIntelligenceLayoutSkillMarkdownHeaderDepth markdownHeaderDepth;

    public DocumentIntelligenceLayoutSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public DocumentIntelligenceLayoutSkillOutputMode getOutputMode() {
        return this.outputMode;
    }

    public DocumentIntelligenceLayoutSkill setOutputMode(DocumentIntelligenceLayoutSkillOutputMode outputMode) {
        this.outputMode = outputMode;
        return this;
    }

    public DocumentIntelligenceLayoutSkillMarkdownHeaderDepth getMarkdownHeaderDepth() {
        return this.markdownHeaderDepth;
    }

    public DocumentIntelligenceLayoutSkill setMarkdownHeaderDepth(DocumentIntelligenceLayoutSkillMarkdownHeaderDepth markdownHeaderDepth) {
        this.markdownHeaderDepth = markdownHeaderDepth;
        return this;
    }

    @Override
    public DocumentIntelligenceLayoutSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public DocumentIntelligenceLayoutSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public DocumentIntelligenceLayoutSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("outputMode", this.outputMode == null ? null : this.outputMode.toString());
        jsonWriter.writeStringField("markdownHeaderDepth", this.markdownHeaderDepth == null ? null : this.markdownHeaderDepth.toString());
        return jsonWriter.writeEndObject();
    }

    public static DocumentIntelligenceLayoutSkill fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentIntelligenceLayoutSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String odataType = "#Microsoft.Skills.Util.DocumentIntelligenceLayoutSkill";
            DocumentIntelligenceLayoutSkillOutputMode outputMode = null;
            DocumentIntelligenceLayoutSkillMarkdownHeaderDepth markdownHeaderDepth = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("outputMode".equals(fieldName)) {
                    outputMode = DocumentIntelligenceLayoutSkillOutputMode.fromString(reader.getString());
                    continue;
                }
                if ("markdownHeaderDepth".equals(fieldName)) {
                    markdownHeaderDepth = DocumentIntelligenceLayoutSkillMarkdownHeaderDepth.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                DocumentIntelligenceLayoutSkill deserializedDocumentIntelligenceLayoutSkill = new DocumentIntelligenceLayoutSkill(inputs, outputs);
                deserializedDocumentIntelligenceLayoutSkill.setName(name);
                deserializedDocumentIntelligenceLayoutSkill.setDescription(description);
                deserializedDocumentIntelligenceLayoutSkill.setContext(context);
                deserializedDocumentIntelligenceLayoutSkill.odataType = odataType;
                deserializedDocumentIntelligenceLayoutSkill.outputMode = outputMode;
                deserializedDocumentIntelligenceLayoutSkill.markdownHeaderDepth = markdownHeaderDepth;
                return deserializedDocumentIntelligenceLayoutSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

