/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AIServicesAccountIdentity;
import com.azure.search.documents.indexes.models.AIServicesAccountKey;
import com.azure.search.documents.indexes.models.CognitiveServicesAccountKey;
import com.azure.search.documents.indexes.models.DefaultCognitiveServicesAccount;
import java.io.IOException;

public class CognitiveServicesAccount
implements JsonSerializable<CognitiveServicesAccount> {
    private String odataType = "CognitiveServicesAccount";
    private String description;

    public String getOdataType() {
        return this.odataType;
    }

    public String getDescription() {
        return this.description;
    }

    public CognitiveServicesAccount setDescription(String description) {
        this.description = description;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static CognitiveServicesAccount fromJson(JsonReader jsonReader) throws IOException {
        return (CognitiveServicesAccount)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                CognitiveServicesAccount cognitiveServicesAccount;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Azure.Search.DefaultCognitiveServices".equals(discriminatorValue)) {
                    cognitiveServicesAccount = DefaultCognitiveServicesAccount.fromJson(readerToUse.reset());
                    return cognitiveServicesAccount;
                }
                if ("#Microsoft.Azure.Search.CognitiveServicesByKey".equals(discriminatorValue)) {
                    cognitiveServicesAccount = CognitiveServicesAccountKey.fromJson(readerToUse.reset());
                    return cognitiveServicesAccount;
                }
                if ("#Microsoft.Azure.Search.AIServicesByKey".equals(discriminatorValue)) {
                    cognitiveServicesAccount = AIServicesAccountKey.fromJson(readerToUse.reset());
                    return cognitiveServicesAccount;
                }
                if ("#Microsoft.Azure.Search.AIServicesByIdentity".equals(discriminatorValue)) {
                    cognitiveServicesAccount = AIServicesAccountIdentity.fromJson(readerToUse.reset());
                    return cognitiveServicesAccount;
                }
                cognitiveServicesAccount = CognitiveServicesAccount.fromJsonKnownDiscriminator(readerToUse.reset());
                return cognitiveServicesAccount;
            }
        });
    }

    static CognitiveServicesAccount fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (CognitiveServicesAccount)jsonReader.readObject(reader -> {
            CognitiveServicesAccount deserializedCognitiveServicesAccount = new CognitiveServicesAccount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    deserializedCognitiveServicesAccount.odataType = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCognitiveServicesAccount.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCognitiveServicesAccount;
        });
    }
}

