/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CharFilterName;
import com.azure.search.documents.indexes.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.models.LexicalNormalizerName;
import com.azure.search.documents.indexes.models.LexicalTokenizerName;
import com.azure.search.documents.indexes.models.TokenFilterName;
import java.io.IOException;
import java.util.List;

public final class AnalyzeRequest
implements JsonSerializable<AnalyzeRequest> {
    private final String text;
    private LexicalAnalyzerName analyzer;
    private LexicalTokenizerName tokenizer;
    private LexicalNormalizerName normalizer;
    private List<TokenFilterName> tokenFilters;
    private List<CharFilterName> charFilters;

    public AnalyzeRequest(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public LexicalAnalyzerName getAnalyzer() {
        return this.analyzer;
    }

    public AnalyzeRequest setAnalyzer(LexicalAnalyzerName analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public LexicalTokenizerName getTokenizer() {
        return this.tokenizer;
    }

    public AnalyzeRequest setTokenizer(LexicalTokenizerName tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    public LexicalNormalizerName getNormalizer() {
        return this.normalizer;
    }

    public AnalyzeRequest setNormalizer(LexicalNormalizerName normalizer) {
        this.normalizer = normalizer;
        return this;
    }

    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    public AnalyzeRequest setTokenFilters(List<TokenFilterName> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    public AnalyzeRequest setCharFilters(List<CharFilterName> charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("analyzer", this.analyzer == null ? null : this.analyzer.toString());
        jsonWriter.writeStringField("tokenizer", this.tokenizer == null ? null : this.tokenizer.toString());
        jsonWriter.writeStringField("normalizer", this.normalizer == null ? null : this.normalizer.toString());
        jsonWriter.writeArrayField("tokenFilters", this.tokenFilters, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("charFilters", this.charFilters, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeRequest)jsonReader.readObject(reader -> {
            boolean textFound = false;
            String text = null;
            LexicalAnalyzerName analyzer = null;
            LexicalTokenizerName tokenizer = null;
            LexicalNormalizerName normalizer = null;
            List tokenFilters = null;
            List charFilters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    textFound = true;
                    continue;
                }
                if ("analyzer".equals(fieldName)) {
                    analyzer = LexicalAnalyzerName.fromString(reader.getString());
                    continue;
                }
                if ("tokenizer".equals(fieldName)) {
                    tokenizer = LexicalTokenizerName.fromString(reader.getString());
                    continue;
                }
                if ("normalizer".equals(fieldName)) {
                    normalizer = LexicalNormalizerName.fromString(reader.getString());
                    continue;
                }
                if ("tokenFilters".equals(fieldName)) {
                    tokenFilters = reader.readArray(reader1 -> TokenFilterName.fromString(reader1.getString()));
                    continue;
                }
                if ("charFilters".equals(fieldName)) {
                    charFilters = reader.readArray(reader1 -> CharFilterName.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            if (textFound) {
                AnalyzeRequest deserializedAnalyzeRequest = new AnalyzeRequest(text);
                deserializedAnalyzeRequest.analyzer = analyzer;
                deserializedAnalyzeRequest.tokenizer = tokenizer;
                deserializedAnalyzeRequest.normalizer = normalizer;
                deserializedAnalyzeRequest.tokenFilters = tokenFilters;
                deserializedAnalyzeRequest.charFilters = charFilters;
                return deserializedAnalyzeRequest;
            }
            throw new IllegalStateException("Missing required property: text");
        });
    }
}

