/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListAliasesResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.SearchAlias;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class AliasesImpl {
    private final AliasesService service;
    private final SearchServiceClientImpl client;

    AliasesImpl(SearchServiceClientImpl client) {
        this.service = (AliasesService)RestProxy.create(AliasesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> createWithResponseAsync(SearchAlias alias, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.createWithResponseAsync(alias, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> createWithResponseAsync(SearchAlias alias, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", alias, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchAlias> createAsync(SearchAlias alias, RequestOptions requestOptions) {
        return this.createWithResponseAsync(alias, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchAlias)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchAlias> createAsync(SearchAlias alias, RequestOptions requestOptions, Context context) {
        return this.createWithResponseAsync(alias, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchAlias)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchAlias> createWithResponse(SearchAlias alias, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", alias, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchAlias create(SearchAlias alias, RequestOptions requestOptions) {
        return (SearchAlias)this.createWithResponse(alias, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SearchAlias>> listSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListAliasesResult)res.getValue()).getAliases(), null, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SearchAlias>> listSinglePageAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.list(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListAliasesResult)res.getValue()).getAliases(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SearchAlias> listAsync(RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listSinglePageAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SearchAlias> listAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(requestOptions, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SearchAlias> listSinglePage(RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListAliasesResult> res = this.service.listSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListAliasesResult)res.getValue()).getAliases(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SearchAlias> listSinglePage(RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListAliasesResult> res = this.service.listSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListAliasesResult)res.getValue()).getAliases(), null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchAlias> list(RequestOptions requestOptions) {
        return new PagedIterable(() -> this.listSinglePage(requestOptions, Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchAlias> list(RequestOptions requestOptions, Context context) {
        return new PagedIterable(() -> this.listSinglePage(requestOptions, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> createOrUpdateWithResponseAsync(String aliasName, SearchAlias alias, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.createOrUpdateWithResponseAsync(aliasName, alias, ifMatch, ifNoneMatch, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> createOrUpdateWithResponseAsync(String aliasName, SearchAlias alias, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdate(this.client.getEndpoint(), aliasName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", alias, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchAlias> createOrUpdateAsync(String aliasName, SearchAlias alias, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.createOrUpdateWithResponseAsync(aliasName, alias, ifMatch, ifNoneMatch, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchAlias)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchAlias> createOrUpdateAsync(String aliasName, SearchAlias alias, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.createOrUpdateWithResponseAsync(aliasName, alias, ifMatch, ifNoneMatch, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchAlias)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchAlias> createOrUpdateWithResponse(String aliasName, SearchAlias alias, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdateSync(this.client.getEndpoint(), aliasName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", alias, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchAlias createOrUpdate(String aliasName, SearchAlias alias, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return (SearchAlias)this.createOrUpdateWithResponse(aliasName, alias, ifMatch, ifNoneMatch, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String aliasName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.deleteWithResponseAsync(aliasName, ifMatch, ifNoneMatch, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String aliasName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.delete(this.client.getEndpoint(), aliasName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String aliasName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.deleteWithResponseAsync(aliasName, ifMatch, ifNoneMatch, requestOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String aliasName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.deleteWithResponseAsync(aliasName, ifMatch, ifNoneMatch, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String aliasName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.deleteSync(this.client.getEndpoint(), aliasName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String aliasName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        this.deleteWithResponse(aliasName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> getWithResponseAsync(String aliasName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.getWithResponseAsync(aliasName, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> getWithResponseAsync(String aliasName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.get(this.client.getEndpoint(), aliasName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchAlias> getAsync(String aliasName, RequestOptions requestOptions) {
        return this.getWithResponseAsync(aliasName, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchAlias)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchAlias> getAsync(String aliasName, RequestOptions requestOptions, Context context) {
        return this.getWithResponseAsync(aliasName, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchAlias)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchAlias> getWithResponse(String aliasName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getSync(this.client.getEndpoint(), aliasName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchAlias get(String aliasName, RequestOptions requestOptions) {
        return (SearchAlias)this.getWithResponse(aliasName, requestOptions, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClientA")
    public static interface AliasesService {
        @Post(value="/aliases")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchAlias>> create(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SearchAlias var5, Context var6);

        @Post(value="/aliases")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchAlias> createSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SearchAlias var5, Context var6);

        @Get(value="/aliases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<ListAliasesResult>> list(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/aliases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<ListAliasesResult> listSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/aliases('{aliasName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchAlias>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="aliasName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") SearchAlias var9, Context var10);

        @Put(value="/aliases('{aliasName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchAlias> createOrUpdateSync(@HostParam(value="endpoint") String var1, @PathParam(value="aliasName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") SearchAlias var9, Context var10);

        @Delete(value="/aliases('{aliasName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="aliasName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/aliases('{aliasName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="aliasName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/aliases('{aliasName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchAlias>> get(@HostParam(value="endpoint") String var1, @PathParam(value="aliasName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/aliases('{aliasName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchAlias> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="aliasName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

