/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.search.documents.SearchDocument;
import com.azure.search.documents.implementation.converters.SearchResultHelper;
import com.azure.search.documents.models.SearchResult;
import java.util.Map;

public final class SearchResultConverter {
    public static SearchResult map(com.azure.search.documents.implementation.models.SearchResult obj, ObjectSerializer serializer) {
        if (obj == null) {
            return null;
        }
        SearchResult searchResult = new SearchResult(obj.getScore());
        SearchResultHelper.setHighlights(searchResult, obj.getHighlights());
        SearchResultHelper.setSemanticSearchResults(searchResult, obj.getRerankerScore(), obj.getCaptions());
        SearchResultHelper.setDocumentDebugInfo(searchResult, obj.getDocumentDebugInfo());
        SearchResultHelper.setAdditionalProperties(searchResult, new SearchDocument((Map<? extends String, ?>)obj.getAdditionalProperties()));
        SearchResultHelper.setJsonSerializer(searchResult, (JsonSerializer)serializer);
        return searchResult;
    }

    private SearchResultConverter() {
    }
}

