/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.batching;

import com.azure.search.documents.implementation.batching.TryTrackingIndexAction;
import com.azure.search.documents.models.IndexAction;
import com.azure.search.documents.options.OnActionAddedOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

final class IndexingDocumentManager<T> {
    private final LinkedList<TryTrackingIndexAction<T>> actions = new LinkedList();
    private final ReentrantLock lock = new ReentrantLock();
    private final Deque<TryTrackingIndexAction<T>> inFlightActions = new LinkedList<TryTrackingIndexAction<T>>();

    IndexingDocumentManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<IndexAction<T>> getActions() {
        this.lock.lock();
        try {
            ArrayList<IndexAction<T>> actions = new ArrayList<IndexAction<T>>(this.inFlightActions.size() + this.actions.size());
            for (TryTrackingIndexAction<T> tryTrackingIndexAction : this.inFlightActions) {
                actions.add(tryTrackingIndexAction.getAction());
            }
            for (TryTrackingIndexAction<Object> tryTrackingIndexAction : this.actions) {
                actions.add(tryTrackingIndexAction.getAction());
            }
            ArrayList<IndexAction<T>> arrayList = actions;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Tuple2<Integer, Boolean> addAndCheckForBatch(Collection<IndexAction<T>> actions, Function<T, String> documentKeyRetriever, Consumer<OnActionAddedOptions<T>> onActionAddedConsumer, int batchSize) {
        this.lock.lock();
        try {
            for (IndexAction<T> action : actions) {
                this.actions.addLast(new TryTrackingIndexAction<T>(action, documentKeyRetriever.apply(action.getDocument())));
                if (onActionAddedConsumer == null) continue;
                onActionAddedConsumer.accept(new OnActionAddedOptions<T>(action));
            }
            int numberOfActions = this.actions.size();
            boolean hasBatch = numberOfActions + this.inFlightActions.size() >= batchSize;
            Tuple2 tuple2 = Tuples.of((Object)numberOfActions, (Object)hasBatch);
            return tuple2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TryTrackingIndexAction<T>> tryCreateBatch(int batchSize, boolean ignoreBatchSize) {
        this.lock.lock();
        try {
            HashSet<String> keysInBatch;
            int actionSize = this.actions.size();
            int inFlightActionSize = this.inFlightActions.size();
            if (!ignoreBatchSize && actionSize + inFlightActionSize < batchSize) {
                List<TryTrackingIndexAction<T>> list = null;
                return list;
            }
            int size = Math.min(batchSize, actionSize + inFlightActionSize);
            ArrayList<TryTrackingIndexAction<T>> batchActions = new ArrayList<TryTrackingIndexAction<T>>(size);
            int inFlightDocumentsAdded = this.fillFromQueue(batchActions, this.inFlightActions, size, keysInBatch = new HashSet<String>(size * 2));
            if (inFlightDocumentsAdded == size) {
                TryTrackingIndexAction<T> inflightAction;
                while ((inflightAction = this.inFlightActions.pollLast()) != null) {
                    this.actions.push(inflightAction);
                }
            } else {
                this.fillFromQueue(batchActions, this.actions, size - inFlightDocumentsAdded, keysInBatch);
            }
            ArrayList<TryTrackingIndexAction<T>> arrayList = batchActions;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int fillFromQueue(List<TryTrackingIndexAction<T>> batch, Collection<TryTrackingIndexAction<T>> queue, int requested, Set<String> duplicateKeyTracker) {
        int actionsAdded = 0;
        Iterator<TryTrackingIndexAction<T>> iterator = queue.iterator();
        while (actionsAdded < requested && iterator.hasNext()) {
            TryTrackingIndexAction<T> potentialDocumentToAdd = iterator.next();
            if (duplicateKeyTracker.contains(potentialDocumentToAdd.getKey())) continue;
            duplicateKeyTracker.add(potentialDocumentToAdd.getKey());
            batch.add(potentialDocumentToAdd);
            iterator.remove();
            ++actionsAdded;
        }
        return actionsAdded;
    }

    void reinsertCancelledActions(List<TryTrackingIndexAction<T>> actionsInFlight) {
        this.lock.lock();
        try {
            this.inFlightActions.addAll(actionsInFlight);
        }
        finally {
            this.lock.unlock();
        }
    }

    void reinsertFailedActions(List<TryTrackingIndexAction<T>> actionsToRetry) {
        this.lock.lock();
        try {
            for (int i = actionsToRetry.size() - 1; i >= 0; --i) {
                this.actions.push(actionsToRetry.get(i));
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

