/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class VectorSearchProfile
implements JsonSerializable<VectorSearchProfile> {
    private final String name;
    private final String algorithmConfigurationName;
    private String vectorizerName;
    private String compressionName;

    public VectorSearchProfile(String name, String algorithmConfigurationName) {
        this.name = name;
        this.algorithmConfigurationName = algorithmConfigurationName;
    }

    public String getName() {
        return this.name;
    }

    public String getAlgorithmConfigurationName() {
        return this.algorithmConfigurationName;
    }

    public String getVectorizerName() {
        return this.vectorizerName;
    }

    public VectorSearchProfile setVectorizerName(String vectorizerName) {
        this.vectorizerName = vectorizerName;
        return this;
    }

    public String getCompressionName() {
        return this.compressionName;
    }

    public VectorSearchProfile setCompressionName(String compressionName) {
        this.compressionName = compressionName;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("algorithm", this.algorithmConfigurationName);
        jsonWriter.writeStringField("vectorizer", this.vectorizerName);
        jsonWriter.writeStringField("compression", this.compressionName);
        return jsonWriter.writeEndObject();
    }

    public static VectorSearchProfile fromJson(JsonReader jsonReader) throws IOException {
        return (VectorSearchProfile)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean algorithmConfigurationNameFound = false;
            String algorithmConfigurationName = null;
            String vectorizerName = null;
            String compressionName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("algorithm".equals(fieldName)) {
                    algorithmConfigurationName = reader.getString();
                    algorithmConfigurationNameFound = true;
                    continue;
                }
                if ("vectorizer".equals(fieldName)) {
                    vectorizerName = reader.getString();
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    compressionName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && algorithmConfigurationNameFound) {
                VectorSearchProfile deserializedVectorSearchProfile = new VectorSearchProfile(name, algorithmConfigurationName);
                deserializedVectorSearchProfile.vectorizerName = vectorizerName;
                deserializedVectorSearchProfile.compressionName = compressionName;
                return deserializedVectorSearchProfile;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!algorithmConfigurationNameFound) {
                missingProperties.add("algorithm");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

