/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class SuggestOptions
implements JsonSerializable<SuggestOptions> {
    private String filter;
    private Boolean useFuzzyMatching;
    private String highlightPostTag;
    private String highlightPreTag;
    private Double minimumCoverage;
    private List<String> orderBy;
    private List<String> searchFields;
    private List<String> select;
    private Integer top;

    public String getFilter() {
        return this.filter;
    }

    public SuggestOptions setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public Boolean useFuzzyMatching() {
        return this.useFuzzyMatching;
    }

    public SuggestOptions setUseFuzzyMatching(Boolean useFuzzyMatching) {
        this.useFuzzyMatching = useFuzzyMatching;
        return this;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public SuggestOptions setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public SuggestOptions setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    public Double getMinimumCoverage() {
        return this.minimumCoverage;
    }

    public SuggestOptions setMinimumCoverage(Double minimumCoverage) {
        this.minimumCoverage = minimumCoverage;
        return this;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public SuggestOptions setOrderBy(List<String> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public List<String> getSearchFields() {
        return this.searchFields;
    }

    public SuggestOptions setSearchFields(List<String> searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    public List<String> getSelect() {
        return this.select;
    }

    public SuggestOptions setSelect(List<String> select) {
        this.select = select;
        return this;
    }

    public Integer getTop() {
        return this.top;
    }

    public SuggestOptions setTop(Integer top) {
        this.top = top;
        return this;
    }

    public SuggestOptions setOrderBy(String ... orderBy) {
        this.orderBy = orderBy == null ? null : Arrays.asList(orderBy);
        return this;
    }

    public SuggestOptions setSearchFields(String ... searchFields) {
        this.searchFields = searchFields == null ? null : Arrays.asList(searchFields);
        return this;
    }

    public SuggestOptions setSelect(String ... select) {
        this.select = select == null ? null : Arrays.asList(select);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("$filter", this.filter);
        jsonWriter.writeBooleanField("UseFuzzyMatching", this.useFuzzyMatching);
        jsonWriter.writeStringField("highlightPostTag", this.highlightPostTag);
        jsonWriter.writeStringField("highlightPreTag", this.highlightPreTag);
        jsonWriter.writeNumberField("minimumCoverage", (Number)this.minimumCoverage);
        jsonWriter.writeArrayField("OrderBy", this.orderBy, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("searchFields", this.searchFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("$select", this.select, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("$top", (Number)this.top);
        return jsonWriter.writeEndObject();
    }

    public static SuggestOptions fromJson(JsonReader jsonReader) throws IOException {
        return (SuggestOptions)jsonReader.readObject(reader -> {
            SuggestOptions deserializedSuggestOptions = new SuggestOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("$filter".equals(fieldName)) {
                    deserializedSuggestOptions.filter = reader.getString();
                    continue;
                }
                if ("UseFuzzyMatching".equals(fieldName)) {
                    deserializedSuggestOptions.useFuzzyMatching = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("highlightPostTag".equals(fieldName)) {
                    deserializedSuggestOptions.highlightPostTag = reader.getString();
                    continue;
                }
                if ("highlightPreTag".equals(fieldName)) {
                    deserializedSuggestOptions.highlightPreTag = reader.getString();
                    continue;
                }
                if ("minimumCoverage".equals(fieldName)) {
                    deserializedSuggestOptions.minimumCoverage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("OrderBy".equals(fieldName)) {
                    List orderBy;
                    deserializedSuggestOptions.orderBy = orderBy = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("searchFields".equals(fieldName)) {
                    List searchFields;
                    deserializedSuggestOptions.searchFields = searchFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("$select".equals(fieldName)) {
                    List select;
                    deserializedSuggestOptions.select = select = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("$top".equals(fieldName)) {
                    deserializedSuggestOptions.top = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSuggestOptions;
        });
    }
}

