/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class AutocompleteItem
implements JsonSerializable<AutocompleteItem> {
    private final String text;
    private final String queryPlusText;

    public AutocompleteItem(String text, String queryPlusText) {
        this.text = text;
        this.queryPlusText = queryPlusText;
    }

    public String getText() {
        return this.text;
    }

    public String getQueryPlusText() {
        return this.queryPlusText;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static AutocompleteItem fromJson(JsonReader jsonReader) throws IOException {
        return (AutocompleteItem)jsonReader.readObject(reader -> {
            boolean textFound = false;
            String text = null;
            boolean queryPlusTextFound = false;
            String queryPlusText = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    textFound = true;
                    continue;
                }
                if ("queryPlusText".equals(fieldName)) {
                    queryPlusText = reader.getString();
                    queryPlusTextFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (textFound && queryPlusTextFound) {
                return new AutocompleteItem(text, queryPlusText);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!textFound) {
                missingProperties.add("text");
            }
            if (!queryPlusTextFound) {
                missingProperties.add("queryPlusText");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

