/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;

public final class WebApiVectorizerParameters
implements JsonSerializable<WebApiVectorizerParameters> {
    private String url;
    private Map<String, String> httpHeaders;
    private String httpMethod;
    private Duration timeout;
    private String authResourceId;
    private SearchIndexerDataIdentity authIdentity;

    public String getUrl() {
        return this.url;
    }

    public WebApiVectorizerParameters setUrl(String url) {
        this.url = url;
        return this;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public WebApiVectorizerParameters setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public WebApiVectorizerParameters setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public WebApiVectorizerParameters setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getAuthResourceId() {
        return this.authResourceId;
    }

    public WebApiVectorizerParameters setAuthResourceId(String authResourceId) {
        this.authResourceId = authResourceId;
        return this;
    }

    public SearchIndexerDataIdentity getAuthIdentity() {
        return this.authIdentity;
    }

    public WebApiVectorizerParameters setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        this.authIdentity = authIdentity;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.url);
        jsonWriter.writeMapField("httpHeaders", this.httpHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("httpMethod", this.httpMethod);
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays((Duration)this.timeout));
        jsonWriter.writeStringField("authResourceId", this.authResourceId);
        jsonWriter.writeJsonField("authIdentity", (JsonSerializable)this.authIdentity);
        return jsonWriter.writeEndObject();
    }

    public static WebApiVectorizerParameters fromJson(JsonReader jsonReader) throws IOException {
        return (WebApiVectorizerParameters)jsonReader.readObject(reader -> {
            WebApiVectorizerParameters deserializedWebApiVectorizerParameters = new WebApiVectorizerParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("uri".equals(fieldName)) {
                    deserializedWebApiVectorizerParameters.url = reader.getString();
                    continue;
                }
                if ("httpHeaders".equals(fieldName)) {
                    Map httpHeaders;
                    deserializedWebApiVectorizerParameters.httpHeaders = httpHeaders = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("httpMethod".equals(fieldName)) {
                    deserializedWebApiVectorizerParameters.httpMethod = reader.getString();
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedWebApiVectorizerParameters.timeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("authResourceId".equals(fieldName)) {
                    deserializedWebApiVectorizerParameters.authResourceId = reader.getString();
                    continue;
                }
                if ("authIdentity".equals(fieldName)) {
                    deserializedWebApiVectorizerParameters.authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebApiVectorizerParameters;
        });
    }
}

