/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.PhoneticEncoder;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class PhoneticTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.PhoneticTokenFilter";
    private PhoneticEncoder encoder;
    private Boolean originalTokensReplaced;

    public PhoneticTokenFilter(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public PhoneticEncoder getEncoder() {
        return this.encoder;
    }

    public PhoneticTokenFilter setEncoder(PhoneticEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public Boolean areOriginalTokensReplaced() {
        return this.originalTokensReplaced;
    }

    public PhoneticTokenFilter setOriginalTokensReplaced(Boolean originalTokensReplaced) {
        this.originalTokensReplaced = originalTokensReplaced;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("encoder", this.encoder == null ? null : this.encoder.toString());
        jsonWriter.writeBooleanField("replace", this.originalTokensReplaced);
        return jsonWriter.writeEndObject();
    }

    public static PhoneticTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (PhoneticTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.PhoneticTokenFilter";
            PhoneticEncoder encoder = null;
            Boolean originalTokensReplaced = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("encoder".equals(fieldName)) {
                    encoder = PhoneticEncoder.fromString(reader.getString());
                    continue;
                }
                if ("replace".equals(fieldName)) {
                    originalTokensReplaced = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                PhoneticTokenFilter deserializedPhoneticTokenFilter = new PhoneticTokenFilter(name);
                deserializedPhoneticTokenFilter.odataType = odataType;
                deserializedPhoneticTokenFilter.encoder = encoder;
                deserializedPhoneticTokenFilter.originalTokensReplaced = originalTokensReplaced;
                return deserializedPhoneticTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

