/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CjkBigramTokenFilterScripts;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class CjkBigramTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.CjkBigramTokenFilter";
    private List<CjkBigramTokenFilterScripts> ignoreScripts;
    private Boolean outputUnigrams;

    public CjkBigramTokenFilter(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public List<CjkBigramTokenFilterScripts> getIgnoreScripts() {
        return this.ignoreScripts;
    }

    public CjkBigramTokenFilter setIgnoreScripts(List<CjkBigramTokenFilterScripts> ignoreScripts) {
        this.ignoreScripts = ignoreScripts;
        return this;
    }

    public Boolean areOutputUnigrams() {
        return this.outputUnigrams;
    }

    public CjkBigramTokenFilter setOutputUnigrams(Boolean outputUnigrams) {
        this.outputUnigrams = outputUnigrams;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeArrayField("ignoreScripts", this.ignoreScripts, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeBooleanField("outputUnigrams", this.outputUnigrams);
        return jsonWriter.writeEndObject();
    }

    public static CjkBigramTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (CjkBigramTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.CjkBigramTokenFilter";
            List ignoreScripts = null;
            Boolean outputUnigrams = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("ignoreScripts".equals(fieldName)) {
                    ignoreScripts = reader.readArray(reader1 -> CjkBigramTokenFilterScripts.fromString(reader1.getString()));
                    continue;
                }
                if ("outputUnigrams".equals(fieldName)) {
                    outputUnigrams = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                CjkBigramTokenFilter deserializedCjkBigramTokenFilter = new CjkBigramTokenFilter(name);
                deserializedCjkBigramTokenFilter.odataType = odataType;
                deserializedCjkBigramTokenFilter.ignoreScripts = ignoreScripts;
                deserializedCjkBigramTokenFilter.outputUnigrams = outputUnigrams;
                return deserializedCjkBigramTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    public CjkBigramTokenFilter setIgnoreScripts(CjkBigramTokenFilterScripts ... ignoreScripts) {
        this.ignoreScripts = ignoreScripts == null ? null : Arrays.asList(ignoreScripts);
        return this;
    }
}

