/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.search.documents.SearchClientBuilder;
import com.azure.search.documents.implementation.SearchIndexClientImpl;
import com.azure.search.documents.implementation.batching.SearchIndexingPublisher;
import com.azure.search.documents.models.IndexAction;
import com.azure.search.documents.models.IndexActionType;
import com.azure.search.documents.options.OnActionAddedOptions;
import com.azure.search.documents.options.OnActionErrorOptions;
import com.azure.search.documents.options.OnActionSentOptions;
import com.azure.search.documents.options.OnActionSucceededOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;

@ServiceClient(builder=SearchClientBuilder.class)
public final class SearchIndexingBufferedSender<T> {
    private static final ClientLogger LOGGER = new ClientLogger(SearchIndexingBufferedSender.class);
    private final boolean autoFlush;
    private final long flushWindowMillis;
    final SearchIndexingPublisher<T> publisher;
    private Timer autoFlushTimer;
    private static final AtomicReferenceFieldUpdater<SearchIndexingBufferedSender, TimerTask> FLUSH_TASK = AtomicReferenceFieldUpdater.newUpdater(SearchIndexingBufferedSender.class, TimerTask.class, "flushTask");
    private volatile TimerTask flushTask;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ReentrantLock closeLock = new ReentrantLock();

    SearchIndexingBufferedSender(SearchIndexClientImpl restClient, JsonSerializer serializer, Function<T, String> documentKeyRetriever, boolean autoFlush, Duration autoFlushInterval, int initialBatchActionCount, int maxRetriesPerAction, Duration throttlingDelay, Duration maxThrottlingDelay, Consumer<OnActionAddedOptions<T>> onActionAddedConsumer, Consumer<OnActionSucceededOptions<T>> onActionSucceededConsumer, Consumer<OnActionErrorOptions<T>> onActionErrorConsumer, Consumer<OnActionSentOptions<T>> onActionSentConsumer) {
        this.publisher = new SearchIndexingPublisher<T>(restClient, serializer, documentKeyRetriever, autoFlush, initialBatchActionCount, maxRetriesPerAction, throttlingDelay, maxThrottlingDelay, onActionAddedConsumer, onActionSucceededConsumer, onActionErrorConsumer, onActionSentConsumer);
        this.autoFlush = autoFlush;
        this.flushWindowMillis = Math.max(0L, autoFlushInterval.toMillis());
        this.autoFlushTimer = this.autoFlush && this.flushWindowMillis > 0L ? new Timer() : null;
    }

    public Collection<IndexAction<T>> getActions() {
        return this.publisher.getActions();
    }

    int getBatchActionCount() {
        return this.publisher.getBatchSize();
    }

    public void addUploadActions(Collection<T> documents) {
        this.addUploadActions(documents, null, Context.NONE);
    }

    public void addUploadActions(Collection<T> documents, Duration timeout, Context context) {
        this.createAndAddActions(documents, IndexActionType.UPLOAD, timeout, context);
    }

    public void addDeleteActions(Collection<T> documents) {
        this.addDeleteActions(documents, null, Context.NONE);
    }

    public void addDeleteActions(Collection<T> documents, Duration timeout, Context context) {
        this.createAndAddActions(documents, IndexActionType.DELETE, timeout, context);
    }

    public void addMergeActions(Collection<T> documents) {
        this.addMergeActions(documents, null, Context.NONE);
    }

    public void addMergeActions(Collection<T> documents, Duration timeout, Context context) {
        this.createAndAddActions(documents, IndexActionType.MERGE, timeout, context);
    }

    public void addMergeOrUploadActions(Collection<T> documents) {
        this.addMergeOrUploadActions(documents, null, Context.NONE);
    }

    public void addMergeOrUploadActions(Collection<T> documents, Duration timeout, Context context) {
        this.createAndAddActions(documents, IndexActionType.MERGE_OR_UPLOAD, timeout, context);
    }

    public void addActions(Collection<IndexAction<T>> actions) {
        this.addActions(actions, null, Context.NONE);
    }

    public void addActions(Collection<IndexAction<T>> actions, Duration timeout, Context context) {
        this.addActionsInternal(actions, timeout, context);
    }

    void createAndAddActions(Collection<T> documents, IndexActionType actionType, Duration timeout, Context context) {
        this.addActionsInternal(SearchIndexingBufferedSender.createDocumentActions(documents, actionType), timeout, context);
    }

    void addActionsInternal(Collection<IndexAction<T>> actions, Duration timeout, Context context) {
        this.ensureOpen();
        this.publisher.addActions(actions, timeout, context, this::rescheduleFlushTask);
    }

    public void flush() {
        this.flush(null, Context.NONE);
    }

    public void flush(Duration timeout, Context context) {
        this.flushInternal(timeout, context);
    }

    void flushInternal(Duration timeout, Context context) {
        this.ensureOpen();
        this.rescheduleFlushTask();
        this.publisher.flush(false, false, timeout, context);
    }

    private void rescheduleFlushTask() {
        if (!this.autoFlush) {
            return;
        }
        TimerTask newTask = new TimerTask(){

            @Override
            public void run() {
                SearchIndexingBufferedSender.this.publisher.flush(false, false, null, Context.NONE);
            }
        };
        TimerTask previousTask = FLUSH_TASK.getAndSet(this, newTask);
        if (previousTask != null) {
            previousTask.cancel();
        }
        this.autoFlushTimer.schedule(newTask, this.flushWindowMillis);
    }

    public void close() {
        this.close(null, Context.NONE);
    }

    public void close(Duration timeout, Context context) {
        this.closeInternal(timeout, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal(Duration timeout, Context context) {
        if (!this.closed.get()) {
            this.closeLock.lock();
            try {
                if (this.closed.compareAndSet(false, true)) {
                    if (this.autoFlush) {
                        TimerTask currentTask = FLUSH_TASK.getAndSet(this, null);
                        if (currentTask != null) {
                            currentTask.cancel();
                        }
                        this.autoFlushTimer.purge();
                        this.autoFlushTimer.cancel();
                        this.autoFlushTimer = null;
                    }
                    this.publisher.flush(true, true, timeout, context);
                }
            }
            finally {
                this.closeLock.unlock();
            }
        }
    }

    private void ensureOpen() {
        if (this.closed.get()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Buffered sender has been closed."));
        }
    }

    private static <T> Collection<IndexAction<T>> createDocumentActions(Collection<T> documents, IndexActionType actionType) {
        ArrayList<IndexAction<T>> actions = new ArrayList<IndexAction<T>>(documents.size());
        for (T document : documents) {
            actions.add(new IndexAction().setActionType(actionType).setDocument(document));
        }
        return actions;
    }
}

