/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import com.azure.search.documents.indexes.models.TextTranslationSkillLanguage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TextTranslationSkill
extends SearchIndexerSkill {
    private final TextTranslationSkillLanguage defaultToLanguageCode;
    private TextTranslationSkillLanguage defaultFromLanguageCode;
    private TextTranslationSkillLanguage suggestedFrom;

    public TextTranslationSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, TextTranslationSkillLanguage defaultToLanguageCode) {
        super(inputs, outputs);
        this.defaultToLanguageCode = defaultToLanguageCode;
    }

    public TextTranslationSkillLanguage getDefaultToLanguageCode() {
        return this.defaultToLanguageCode;
    }

    public TextTranslationSkillLanguage getDefaultFromLanguageCode() {
        return this.defaultFromLanguageCode;
    }

    public TextTranslationSkill setDefaultFromLanguageCode(TextTranslationSkillLanguage defaultFromLanguageCode) {
        this.defaultFromLanguageCode = defaultFromLanguageCode;
        return this;
    }

    public TextTranslationSkillLanguage getSuggestedFrom() {
        return this.suggestedFrom;
    }

    public TextTranslationSkill setSuggestedFrom(TextTranslationSkillLanguage suggestedFrom) {
        this.suggestedFrom = suggestedFrom;
        return this;
    }

    @Override
    public TextTranslationSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public TextTranslationSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public TextTranslationSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Skills.Text.TranslationSkill");
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("defaultToLanguageCode", Objects.toString((Object)this.defaultToLanguageCode, null));
        jsonWriter.writeStringField("defaultFromLanguageCode", Objects.toString((Object)this.defaultFromLanguageCode, null));
        jsonWriter.writeStringField("suggestedFrom", Objects.toString((Object)this.suggestedFrom, null));
        return jsonWriter.writeEndObject();
    }

    public static TextTranslationSkill fromJson(JsonReader jsonReader) throws IOException {
        return (TextTranslationSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            boolean defaultToLanguageCodeFound = false;
            TextTranslationSkillLanguage defaultToLanguageCode = null;
            TextTranslationSkillLanguage defaultFromLanguageCode = null;
            TextTranslationSkillLanguage suggestedFrom = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Skills.Text.TranslationSkill".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.TranslationSkill'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("defaultToLanguageCode".equals(fieldName)) {
                    defaultToLanguageCode = TextTranslationSkillLanguage.fromString(reader.getString());
                    defaultToLanguageCodeFound = true;
                    continue;
                }
                if ("defaultFromLanguageCode".equals(fieldName)) {
                    defaultFromLanguageCode = TextTranslationSkillLanguage.fromString(reader.getString());
                    continue;
                }
                if ("suggestedFrom".equals(fieldName)) {
                    suggestedFrom = TextTranslationSkillLanguage.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound && defaultToLanguageCodeFound) {
                TextTranslationSkill deserializedTextTranslationSkill = new TextTranslationSkill(inputs, outputs, defaultToLanguageCode);
                deserializedTextTranslationSkill.setName(name);
                deserializedTextTranslationSkill.setDescription(description);
                deserializedTextTranslationSkill.setContext(context);
                deserializedTextTranslationSkill.defaultFromLanguageCode = defaultFromLanguageCode;
                deserializedTextTranslationSkill.suggestedFrom = suggestedFrom;
                return deserializedTextTranslationSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            if (!defaultToLanguageCodeFound) {
                missingProperties.add("defaultToLanguageCode");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

