/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.StopwordsList;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class StopwordsTokenFilter
extends TokenFilter {
    private List<String> stopwords;
    private StopwordsList stopwordsList;
    private Boolean caseIgnored;
    private Boolean trailingStopWordsRemoved;

    public StopwordsTokenFilter(String name) {
        super(name);
    }

    public List<String> getStopwords() {
        return this.stopwords;
    }

    public StopwordsTokenFilter setStopwords(List<String> stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    public StopwordsList getStopwordsList() {
        return this.stopwordsList;
    }

    public StopwordsTokenFilter setStopwordsList(StopwordsList stopwordsList) {
        this.stopwordsList = stopwordsList;
        return this;
    }

    public Boolean isCaseIgnored() {
        return this.caseIgnored;
    }

    public StopwordsTokenFilter setCaseIgnored(Boolean caseIgnored) {
        this.caseIgnored = caseIgnored;
        return this;
    }

    public Boolean areTrailingStopWordsRemoved() {
        return this.trailingStopWordsRemoved;
    }

    public StopwordsTokenFilter setTrailingStopWordsRemoved(Boolean trailingStopWordsRemoved) {
        this.trailingStopWordsRemoved = trailingStopWordsRemoved;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.StopwordsTokenFilter");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("stopwords", this.stopwords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("stopwordsList", Objects.toString((Object)this.stopwordsList, null));
        jsonWriter.writeBooleanField("ignoreCase", this.caseIgnored);
        jsonWriter.writeBooleanField("removeTrailing", this.trailingStopWordsRemoved);
        return jsonWriter.writeEndObject();
    }

    public static StopwordsTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (StopwordsTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            List stopwords = null;
            StopwordsList stopwordsList = null;
            Boolean caseIgnored = null;
            Boolean trailingStopWordsRemoved = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.StopwordsTokenFilter".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.StopwordsTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("stopwords".equals(fieldName)) {
                    stopwords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("stopwordsList".equals(fieldName)) {
                    stopwordsList = StopwordsList.fromString(reader.getString());
                    continue;
                }
                if ("ignoreCase".equals(fieldName)) {
                    caseIgnored = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("removeTrailing".equals(fieldName)) {
                    trailingStopWordsRemoved = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                StopwordsTokenFilter deserializedStopwordsTokenFilter = new StopwordsTokenFilter(name);
                deserializedStopwordsTokenFilter.stopwords = stopwords;
                deserializedStopwordsTokenFilter.stopwordsList = stopwordsList;
                deserializedStopwordsTokenFilter.caseIgnored = caseIgnored;
                deserializedStopwordsTokenFilter.trailingStopWordsRemoved = trailingStopWordsRemoved;
                return deserializedStopwordsTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public StopwordsTokenFilter setStopwords(String ... stopwords) {
        this.stopwords = stopwords == null ? null : Arrays.asList(stopwords);
        return this;
    }
}

